/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataApi.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.dataShare.dataApi.manager.BizServiceApiManager;
import com.artfess.dataShare.dataApi.model.BizServiceApi;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.sql.SQLException;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/biz/dataApi/serviceApi/v1/"})
@Api(tags={"\u6570\u636e\u8d44\u4ea7-\u6570\u636e\u670d\u52a1\u63a5\u53e3\u4fe1\u606f"})
@ApiGroup(group={"group_biz_dataShare"})
public class BizServiceApiController
extends BaseController<BizServiceApiManager, BizServiceApi> {
    @ApiOperation(value="\u6ce8\u518c\u63a5\u53e3\u914d\u7f6e")
    @PostMapping(value={"register"})
    public CommonResult<String> register(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) BizServiceApi serviceApi) throws Exception {
        boolean status = ((BizServiceApiManager)this.baseService).register(serviceApi);
        return status ? CommonResult.success(null, (String)"\u6ce8\u518c\u63a5\u53e3\u914d\u7f6e\u6210\u529f") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation(value="\u53d1\u5e03\u63a5\u53e3")
    @PutMapping(value={"publish"})
    public CommonResult<String> publish(@RequestParam String id) {
        boolean status = ((BizServiceApiManager)this.baseService).publish(id);
        return status ? CommonResult.success(null, (String)"\u53d1\u5e03\u6210\u529f") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation(value="\u4e0b\u67b6\u63a5\u53e3")
    @PutMapping(value={"soldOut"})
    public CommonResult<String> soldOut(@RequestParam String id) {
        boolean status = ((BizServiceApiManager)this.baseService).soldOut(id);
        return status ? CommonResult.success(null, (String)"\u4e0b\u67b6\u6210\u529f") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation(value="\u9a8c\u8bc1SQL\u8bed\u53e5\u7684\u53ef\u7528\u6027")
    @PostMapping(value={"checkSqlValidity"})
    public CommonResult<String> checkSqlValidity(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) BizServiceApi serviceApi) throws SQLException {
        boolean status = ((BizServiceApiManager)this.baseService).checkSqlValidity(serviceApi);
        return status ? CommonResult.success(null, (String)"sql\u9a8c\u8bc1\u6210\u529f") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u91cd\u590d\u63a5\u53e3")
    @PostMapping(value={"checkApiValidity"})
    public CommonResult<String> checkApiValidity(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) BizServiceApi serviceApi) throws SQLException {
        boolean status = ((BizServiceApiManager)this.baseService).checkApiValidity(serviceApi);
        return status ? CommonResult.success(null, (String)"sql\u9a8c\u8bc1\u6210\u529f") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u91cd\u590d\u7f16\u7801")
    @PostMapping(value={"checkApiCode"})
    public CommonResult<String> checkApiCode(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) BizServiceApi serviceApi) throws SQLException {
        boolean status = ((BizServiceApiManager)this.baseService).checkApiCode(serviceApi);
        return status ? CommonResult.success(null, (String)"\u7f16\u7801\u53ef\u4ee5\u4f7f\u7528") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation(value="\u5220\u9664\u63a5\u53e3\u914d\u7f6e")
    @DeleteMapping(value={"unregister"})
    public CommonResult<String> unregister(@RequestParam(value="id") String id) {
        boolean status = ((BizServiceApiManager)this.baseService).unregister(id);
        return status ? CommonResult.success(null, (String)"\u5220\u9664\u63a5\u53e3\u914d\u7f6e\u6210\u529f") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation(value="\u4fee\u6539\u63a5\u53e3\u914d\u7f6e")
    @PutMapping(value={"updateServiceApi"})
    public CommonResult<String> updateServiceApi(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) BizServiceApi serviceApi) {
        boolean status = ((BizServiceApiManager)this.baseService).updateServiceApi(serviceApi);
        return status ? CommonResult.success(null, (String)"\u4fee\u6539\u63a5\u53e3\u914d\u7f6e\u6210\u529f") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation(value="\u67e5\u8be2\u63a5\u53e3\u914d\u7f6e")
    @PostMapping(value={"queryApi"})
    public PageList<BizServiceApi> queryApi(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizServiceApi> queryFilter) {
        return ((BizServiceApiManager)this.baseService).queryApi(queryFilter);
    }

    @ApiOperation(value="\u67e5\u770b\u63a5\u53e3\u8be6\u60c5")
    @GetMapping(value={"getInfo/{id}"})
    public CommonResult<BizServiceApi> getInfo(@PathVariable(value="id") String id) {
        BizServiceApi serviceApi = ((BizServiceApiManager)this.baseService).getInfo(id);
        return CommonResult.success((Object)((Object)serviceApi), (String)"\u83b7\u53d6\u6210\u529f");
    }

    @ApiOperation(value="\u6d4f\u89c8\u63a5\u53e3\u6587\u6863")
    @GetMapping(value={"viewApiDocument/{id}"})
    public CommonResult<BizServiceApi> viewApiDocument(@PathVariable(value="id") String id) throws IOException {
        BizServiceApi serviceApi = ((BizServiceApiManager)this.baseService).viewApiDocument(id);
        return CommonResult.success((Object)((Object)serviceApi), (String)"\u83b7\u53d6\u6210\u529f");
    }
}

