/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util.string;

import org.apache.commons.lang.StringUtils;

public class StringValidator {
    public static boolean isNumberic(String s) {
        boolean rtn = StringValidator.valid("^[-+]{0,1}\\d*\\.{0,1}\\d+$", s);
        if (rtn) {
            return true;
        }
        return StringValidator.valid("^0[x|X][\\da-eA-E]+$", s);
    }

    public static boolean isInteger(String s) {
        return StringValidator.valid("^[-+]{0,1}\\d*$", s);
    }

    public static boolean isEmail(String s) {
        return StringValidator.valid("(\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*)*", s);
    }

    public static boolean isMobile(String s) {
        return StringValidator.valid("^(((13[0-9]{1})|(15[0-9]{1})|(18[0-9]{1}))+\\d{8})$", s);
    }

    public static boolean isPhone(String s) {
        return StringValidator.valid("(0[0-9]{2,3}\\-)?([2-9][0-9]{6,7})+(\\-[0-9]{1,4})?", s);
    }

    public static boolean isZip(String s) {
        return StringValidator.valid("^[0-9]{6}$", s);
    }

    public static boolean isQq(String s) {
        return StringValidator.valid("^[1-9]\\d{4,9}$", s);
    }

    public static boolean isIp(String s) {
        return StringValidator.valid("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$", s);
    }

    public static boolean isChinese(String s) {
        return StringValidator.valid("^[\u4e00-\u9fa5]+$", s);
    }

    public static boolean isChrNum(String s) {
        return StringValidator.valid("^([a-zA-Z0-9]+)$", s);
    }

    public static boolean isUrl(String url) {
        return StringValidator.valid("(http://|https://)?([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?", url);
    }

    public static boolean valid(String regex, String input) {
        if (StringUtils.isEmpty((String)regex)) {
            return false;
        }
        boolean matches = input.matches(regex);
        return matches;
    }
}

