/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfFinanceLeaseMDao;
import com.artfess.cqlt.manager.QfFinanceLeaseDManager;
import com.artfess.cqlt.manager.QfFinanceLeaseMManager;
import com.artfess.cqlt.model.QfFinanceLeaseD;
import com.artfess.cqlt.model.QfFinanceLeaseM;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class QfFinanceLeaseMManagerImpl
extends BaseManagerImpl<QfFinanceLeaseMDao, QfFinanceLeaseM>
implements QfFinanceLeaseMManager {
    @Autowired
    private QfFinanceLeaseDManager financeLeaseDManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<QfFinanceLeaseD> list, String mainId) {
        QfFinanceLeaseM financeLeaseM = (QfFinanceLeaseM)((Object)((QfFinanceLeaseMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)financeLeaseM), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        Assert.isTrue((!"1".equals(financeLeaseM.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.financeLeaseDManager.remove((Wrapper)queryWrapper);
        list.forEach(detail -> {
            detail.setFillDate(financeLeaseM.getFillDate());
            detail.setMainId(mainId);
        });
        boolean b = this.financeLeaseDManager.saveBatch(list);
        return b;
    }

    @Override
    public boolean updateStatus(QfFinanceLeaseM t) {
        QfFinanceLeaseM financeLeaseM = (QfFinanceLeaseM)((Object)((QfFinanceLeaseMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == financeLeaseM) {
            return false;
        }
        financeLeaseM.setStatus(financeLeaseM.getStatus() == 0 ? 1 : 0);
        int i = ((QfFinanceLeaseMDao)this.baseMapper).updateById((Object)financeLeaseM);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfFinanceLeaseM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List financeLeaseMS = ((QfFinanceLeaseMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)financeLeaseMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceLeaseMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfFinanceLeaseM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List financeLeaseMS = ((QfFinanceLeaseMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)financeLeaseMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceLeaseMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }
}

