package com.artfess.uc.manager;

import org.springframework.web.multipart.MultipartFile;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.uc.model.ElectronicSeal;
import com.artfess.uc.params.seal.ImportSignatureObject;

/**
 * 
 * <pre> 
 * 描述：uc_electronic_seal 处理接口
 * 构建组：x7
 * 作者:lihq
 * 邮箱:lihq@jee-soft.cn
 * 日期:2020-10-19 18:18:31
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
public interface ElectronicSealManager extends BaseManager<ElectronicSeal>{

    /**
     * 将状态改为已过期
     * @param id
     */
    void setIsUse(String id);
    
    /**
     * 处理批量导入的用户签章数据
     * @param signatureData
     * @return
     * @throws Exception 
     */
    CommonResult<String> importSignature(ImportSignatureObject signatureData) throws Exception;
}
