package com.artfess.uc.context;

import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

import com.artfess.base.constants.TenantConstant;
import com.artfess.base.context.BaseContext;
import com.artfess.base.exception.BaseException;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ContextThread;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.manager.TenantManageManager;
import com.artfess.uc.model.TenantManage;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;

/**
 * uc 和 uc-api-impl 中各自有一个UCContext
 *
 * @author liyanggui
 *
 */
@Service
@Primary
public class UcContext implements BaseContext,ContextThread{

	private ThreadLocal<String> tempTenantId = new ThreadLocal<>();

	public void setTempTenantId(String tenantId) {
		tempTenantId.set(tenantId);
	}

	public void clearTempTenantId() {
		this.tempTenantId.remove();
	}

	@Override
	public String getCurrentUserId() {
		if (authenticationEmpty()) {
			return null;
		}
		return ContextUtil.getCurrentUserId();
	}

	@Override
	public String getCurrentUserAccout() {
		if (authenticationEmpty()) {
			return null;
		}
		return ContextUtil.getCurrentUser().getAccount();
	}

	@Override
	public String getCurrentUserName() {
		if (authenticationEmpty()) {
			return null;
		}
		return ContextUtil.getCurrentUser().getFullname();
	}

	@Override
	public String getCurrentOrgId() {
		if (authenticationEmpty()) {
			return null;
		}
		return ContextUtil.getCurrentOrgId();
		//return ContextUtil.getCurrentGroupId();
	}

	@Override
	public String getCurrentOrgName() {
		if (authenticationEmpty()) {
			return null;
		}
		return ContextUtil.getCurrentOrgName();
	}

	@Override
	public String getCurrentDeptId() {
		if (authenticationEmpty()) {
			return null;
		}
		return ContextUtil.getCurrentDeptId();
	}

	@Override
	public String getCurrentDeptName() {
		if (authenticationEmpty()) {
			return null;
		}
		return ContextUtil.getCurrentDeptName();
	}

	@Override
	public String getCurrentTenantId() {
		String tempTenantId = this.tempTenantId.get();
		if (StringUtil.isNotEmpty(tempTenantId)) {
			return tempTenantId;
		}

		String tenantId = HttpUtil.getTenantId();
		if (BeanUtils.isNotEmpty(tenantId)) {
			return tenantId;
		}

		if (authenticationEmpty()) {
			return TenantConstant.PLATFORM_TENANT_ID;
		}
		User currentUser = ContextUtil.getCurrentUser();
		if (BeanUtils.isEmpty(currentUser)) {
			String tenantCode = HttpUtil.getRequest().getHeader("Tenant-Code");
			TenantManageManager tenantManageManager = AppUtil.getBean(TenantManageManager.class);
			TenantManage tenantManage = tenantManageManager.getByCode(tenantCode);
			if (BeanUtils.isNotEmpty(tenantManage)) {
				String status = tenantManage.getStatus();
				if(TenantManage.STATUS_DRAFT.equals(status)) {
					throw new BaseException("草稿状态的租户不允许登录");
				}
				return tenantManage.getId();
			}
			return TenantConstant.PLATFORM_TENANT_ID;
		}
		return ContextUtil.getCurrentUser().getTenantId();
	}

	/**
	 * 兼容单元测试
	 *
	 * @return
	 */
	private boolean authenticationEmpty() {
		Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
		if (BeanUtils.isEmpty(authentication) || authentication instanceof AnonymousAuthenticationToken) {
			return true;
		}
		return false;
	}

	@Override
	public void cleanAll() {
		clearTempTenantId();
	}
}
