package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.portal.manager.CommonBasicManager;
import com.artfess.portal.model.CommonBasic;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhx
 * @create 2021/6/9
 */
@RestController
@RequestMapping(value = "/portal/commonBasic/v1")
@Api(tags = "系统信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_SYSTEM})
public class CommonBasicController extends BaseController<CommonBasicManager, CommonBasic> {
    @Autowired
    private CommonBasicManager commonBasicManager;

    @RequestMapping(value = "getOne", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取一条SysCommonBasic对象", httpMethod = "GET", notes = "系统基本设置")
    public CommonBasic getOne() {
        return commonBasicManager.getOne();
    }

}
