package com.artfess.yhxt.yjjy.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2022-05-30
 */
@ApiModel(value="DiseasesYjjy对象", description="应急救援-巡检点")
@TableName("biz_diseases_yjjy")
@Data
public class DiseasesYjjy extends BaseModel<DiseasesYjjy> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "路段编号")
    @TableField("s_road_")
    private String sRoad;

    @ApiModelProperty(value = "巡检点类型")
    @TableField("s_value_")
    private String sValue;

    @ApiModelProperty(value = "巡检点状态")
    @TableField("s_status_")
    private String sStatus;

    @ApiModelProperty(value = "巡检点内容")
    @TableField("s_check_message_")
    private String sCheckMessage;

    @ApiModelProperty(value = "巡检点是否处理")
    @TableField("s_do_result_")
    private String sDoreSult;

    @TableField("s_do_value_")
    private String sDoValue;

    @TableField("s_do_person_")
    private String sDoPerson;

    @ApiModelProperty(value = "方向")
    @TableField("s_dir_")
    private String sDir;

    @TableField("s_type_")
    private String sType;


    @ApiModelProperty(value = "种类")
    @TableField("s_kind_")
    private String sKind;

    @TableField("s_name_")
    private String sName;
    @TableField("n_id_")
    private String nId;

    @TableField("s_longitude_")
    @ApiModelProperty(value = "经度")
    private String sLongitude;

    @TableField("s_latitude_")
    @ApiModelProperty(value = "纬度")
    private String sLatitude;
    @TableField("d_create_date_")
    @ApiModelProperty(value = "时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime dCreateDate;



}
