package com.artfess.yhxt.thirdparty.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.thirdparty.model.BizTpBridge;
import com.artfess.yhxt.thirdparty.vo.TpBridgeCountVo;
import com.artfess.yhxt.thirdparty.vo.TpBridgePageVo;
import com.artfess.yhxt.thirdparty.vo.TpDeviceCountVo;
import com.artfess.yhxt.thirdparty.vo.TpDeviceTypeCountVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.thirdparty.model.BizTpDevice;
import com.artfess.yhxt.thirdparty.manager.BizTpDeviceManager;

import java.util.List;
import java.util.Map;

/**
 * 第三方传输设备基础信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-06-15
 */
@RestController
@RequestMapping("/bizTpDevice/v1/")
@Api(tags = "第三方传输设备基础信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizTpDeviceController extends BaseController<BizTpDeviceManager, BizTpDevice> {



    /**
     * 获取设备类型统计
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "getDeviceCount", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取设备类型统计", httpMethod = "POST", notes = "获取设备类型统计")
    public TpDeviceCountVo getDeviceCount(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizTpDevice> queryFilter) {
        return baseService.getDeviceCount(queryFilter);
    }


    @RequestMapping(value = "pageVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value ="分页查询结果", httpMethod = "POST", notes = "分页查询结果")
    public PageList<BizTpDevice> page(@ApiParam(name="queryFilter", value="分页查询结果") @RequestBody QueryFilter<BizTpDevice> queryFilter) {

        return baseService.pageVo(queryFilter);
    }

    @RequestMapping(value = "getDeviceTypeCount", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value ="设备基础信息", httpMethod = "POST", notes = "设备基础信息")
    public Map<String, TpDeviceTypeCountVo> getDeviceTypeCount(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizTpDevice> queryFilter) {

        return baseService.getDeviceTypeCount(queryFilter);
    }

    @RequestMapping(value = "deviceCountTotal", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value ="设备信息统计", httpMethod = "POST", notes = "设备信息统计")
    public  TpDeviceTypeCountVo deviceCountTotal(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizTpDevice> queryFilter) {

        return baseService.deviceCountTotal(queryFilter);
    }





}
