package com.artfess.yhxt.statistics.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author zhx
 * @create 2021/10/27
 */
@Data
@ApiModel(value="YearBudgetSum", description="金额")
@TableName("biz_money_statistic")
public class YearBudgetSum extends BaseModel<YearBudgetSum> {
    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "所在路段id(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所在路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "预算总额")
    @TableField("BUDGET_SUM_")
    private String budgetSum="0";

    @ApiModelProperty(value = "已用总额")
    @TableField("ALREADY_COUNT_")
    private String alreadyCount="0";

    @ApiModelProperty(value = "日常养护计费(万元)")
    @TableField("CONSERVE_MONEY_")
    private String conserveMoney="0";

    @ApiModelProperty(value = "专项养护项目计费金额(万元)")
    @TableField("SPECIAL_MONEY_")
    private String specialMoney="0";
    @ApiModelProperty(value = "抢险养护项目计费金额(万元)")
    @TableField("RUSH_MONEY_")
    private String rushMoney="0";


    @ApiModelProperty(value = "日常养护预算(万元)")
    @TableField("CONSERVE_MONEY_BUDGET_")
    private String conserveMoneyBudget="0";

    @ApiModelProperty(value = "预算专项项预算(万元)")
    @TableField("SPECIAL_MONEY_BUDGET_")
    private String specialMoneyBudget="0";

    @ApiModelProperty(value = "抢险养护项目预算金额(万元)")
    @TableField("RUSH_MONEY_BUDGET_")
    private String rushMoneyBudget="0";

    @ApiModelProperty(value = "年份")
    @TableField("ACC_DATE_YEAR_")
    private Integer accDateYear;


}
