package com.artfess.yhxt.statistics.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 数据大屏-巡检统计表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-10-26
 */
@ApiModel(value="BizSiteStatistic对象", description="数据大屏-巡检统计表")
@TableName("BIZ_SITE_STATISTIC")
public class SiteStatistic extends BaseModel<SiteStatistic> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "所在路段id(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所在路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "巡检类型名称")
    @TableField("SITE_NAME_")
    private String siteName;

    @ApiModelProperty(value = "巡检类型编码")
    @TableField("SITE_CODE_")
    private Integer siteCode;

    @ApiModelProperty(value = "月份（2021-08）")
    @TableField("ACC_DATE_MONTH_")
    private String accDateMonth;

    @ApiModelProperty(value = "年份（2021）")
    @TableField("ACC_DATE_YEAR_")
    private String accDateYear;

    @ApiModelProperty(value = "完成数量")
    @TableField("COMPLETE_")
    private String complete;

    @ApiModelProperty(value = "未完成数量")
    @TableField("COMPLETE_NO_")
    private String completeNo;

    @ApiModelProperty(value = "完成数量")
    @TableField(exist = false)
    private Integer completeTotal;

    @ApiModelProperty(value = "未完成数量")
    @TableField(exist = false)
    private Integer completeNoTotal;


    @ApiModelProperty(value = "日巡检已完成")
    @TableField(exist = false)
    private Integer dayCheckingFinish;
    @ApiModelProperty(value = "日巡检未完成")
    @TableField(exist = false)
    private Integer dayCheckingOnFinsh;

    @ApiModelProperty(value = "夜巡检已完成")
    @TableField(exist = false)
    private Integer nightCheckingFinish;
    @ApiModelProperty(value = "夜巡检未完成")
    @TableField(exist = false)
    private Integer nightCheckingOnFinsh;

    public Integer getDayCheckingFinish() {
        return dayCheckingFinish;
    }

    public void setDayCheckingFinish(Integer dayCheckingFinish) {
        this.dayCheckingFinish = dayCheckingFinish;
    }

    public Integer getDayCheckingOnFinsh() {
        return dayCheckingOnFinsh;
    }

    public void setDayCheckingOnFinsh(Integer dayCheckingOnFinsh) {
        this.dayCheckingOnFinsh = dayCheckingOnFinsh;
    }

    public Integer getNightCheckingFinish() {
        return nightCheckingFinish;
    }

    public void setNightCheckingFinish(Integer nightCheckingFinish) {
        this.nightCheckingFinish = nightCheckingFinish;
    }

    public Integer getNightCheckingOnFinsh() {
        return nightCheckingOnFinsh;
    }

    public void setNightCheckingOnFinsh(Integer nightCheckingOnFinsh) {
        this.nightCheckingOnFinsh = nightCheckingOnFinsh;
    }

    public Integer getCompleteTotal() {
        return completeTotal;
    }

    public void setCompleteTotal(Integer completeTotal) {
        this.completeTotal = completeTotal;
    }

    public Integer getCompleteNoTotal() {
        return completeNoTotal;
    }

    public void setCompleteNoTotal(Integer completeNoTotal) {
        this.completeNoTotal = completeNoTotal;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public String getRoadSegmentId() {
        return roadSegmentId;
    }

    public void setRoadSegmentId(String roadSegmentId) {
        this.roadSegmentId = roadSegmentId;
    }
    public String getRoadSegmentName() {
        return roadSegmentName;
    }

    public void setRoadSegmentName(String roadSegmentName) {
        this.roadSegmentName = roadSegmentName;
    }
    public String getSiteName() {
        return siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }
    public Integer getSiteCode() {
        return siteCode;
    }

    public void setSiteCode(Integer siteCode) {
        this.siteCode = siteCode;
    }
    public String getAccDateMonth() {
        return accDateMonth;
    }

    public void setAccDateMonth(String accDateMonth) {
        this.accDateMonth = accDateMonth;
    }
    public String getAccDateYear() {
        return accDateYear;
    }

    public void setAccDateYear(String accDateYear) {
        this.accDateYear = accDateYear;
    }
    public String getComplete() {
        return complete;
    }

    public void setComplete(String complete) {
        this.complete = complete;
    }
    public String getCompleteNo() {
        return completeNo;
    }

    public void setCompleteNo(String completeNo) {
        this.completeNo = completeNo;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizSiteStatistic{" +
            "id=" + id +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
            ", roadSegmentId=" + roadSegmentId +
            ", roadSegmentName=" + roadSegmentName +
            ", siteName=" + siteName +
            ", siteCode=" + siteCode +
            ", accDateMonth=" + accDateMonth +
            ", accDateYear=" + accDateYear +
            ", complete=" + complete +
            ", completeNo=" + completeNo +
        "}";
    }
}
