package com.artfess.yhxt.statistics.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.yhxt.statistics.manager.WorkbenchManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import java.util.Map;

/**
 * @author zhx
 * @create 2021/11/2
 */

@RestController
@RequestMapping("/workbench/v1/")
@Api(tags = "工作台统计接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class WorkbenchController {
    @Autowired
    private WorkbenchManager workbenchManager;

    @RequestMapping(value = "getWorkOrder", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "待办工单", httpMethod = "POST")
    public Map<String, Object> getWorkOrder() {
        return this.workbenchManager.getWorkOrder();
    }


    @RequestMapping(value = "getOverdue", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逾期超时", httpMethod = "POST")
    public Map<String, Object> getOverdue() {
        return this.workbenchManager.getOverdue();
    }


    @RequestMapping(value = "getRegularCheck", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "定期检查", httpMethod = "POST")
    public Map<String, Object> getRegularCheck() {
        return this.workbenchManager.getRegularCheck();
    }

    @RequestMapping(value = "getOftenCheck", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "经常检查", httpMethod = "POST")
    public Map<String, Object> getOftenCheck() {
        return this.workbenchManager.getOftenCheck();
    }
}
