package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 民工信息表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-11
 */
@ApiModel(value="BizMigrantWorkersInformation对象", description="民工信息表")
@TableName("biz_migrant_workers_information")
@Data
public class BizMigrantWorkersInformation extends BizModel<BizMigrantWorkersInformation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "路段id")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "项目id")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "项目name")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "业务主键id")
    @TableField("WORKER_ID_")
    private String workerId;

    @ApiModelProperty(value = "工人姓名")
    @TableField("WORKER_NAME_")
    private String workerName;

    @ApiModelProperty(value = "身份证号码")
    @TableField("ID_NUMBER_")
    private String idNumber;

    @ApiModelProperty(value = "性别")
    @TableField("GENDER_")
    private String gender;

    @ApiModelProperty(value = "年龄")
    @TableField("AGE_")
    private Integer age;

    @ApiModelProperty(value = "手机号码")
    @TableField("PHONE_NUM_")
    private String phoneNum;

    @ApiModelProperty(value = "保险生效时间")
    @TableField("INSURANCE_START_DATE_")
    private String insuranceStartDate;

    @ApiModelProperty(value = "保险到期时间")
    @TableField("INSURANCE_END_DATE_")
    private String insuranceEndDate;

    @ApiModelProperty(value = "保额")
    @TableField("INSURANCE_AMOUNT_")
    private String insuranceAmount;

    @ApiModelProperty(value = "民族")
    @TableField("NATION_")
    private String nation;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "所属单位名称")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "所属单位id")
    @TableField("UNIT_ID_")
    private String unitId;
    @ApiModelProperty(value = "所属单位IDs")
    @TableField("UNIT_IDS_")
    private String unitIds;

    @ApiModelProperty(value = "所属项目")
    @TableField("MAIN_PROJECT_ID_")
    private String mainProjectId;

    @ApiModelProperty(value = "1-有效（默认值）、0-无效")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "培训课时")
    @TableField("COURSE_HOURS_")
    private BigDecimal courseHours;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getWorkerId() {
        return workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }
    public String getWorkerName() {
        return workerName;
    }

    public void setWorkerName(String workerName) {
        this.workerName = workerName;
    }
    public String getIdNumber() {
        return idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }
    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }
    public Integer getAge() {
        return age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }
    public String getPhoneNum() {
        return phoneNum;
    }

    public void setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
    }
    public String getInsuranceStartDate() {
        return insuranceStartDate;
    }

    public void setInsuranceStartDate(String insuranceStartDate) {
        this.insuranceStartDate = insuranceStartDate;
    }
    public String getInsuranceEndDate() {
        return insuranceEndDate;
    }

    public void setInsuranceEndDate(String insuranceEndDate) {
        this.insuranceEndDate = insuranceEndDate;
    }
    public String getInsuranceAmount() {
        return insuranceAmount;
    }

    public void setInsuranceAmount(String insuranceAmount) {
        this.insuranceAmount = insuranceAmount;
    }
    public String getNation() {
        return nation;
    }

    public void setNation(String nation) {
        this.nation = nation;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public String getUnitId() {
        return unitId;
    }

    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }
    public String getMainProjectId() {
        return mainProjectId;
    }

    public void setMainProjectId(String mainProjectId) {
        this.mainProjectId = mainProjectId;
    }
    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getUnitIds() {
        return unitIds;
    }

    public void setUnitIds(String unitIds) {
        this.unitIds = unitIds;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizMigrantWorkersInformation{" +
            "id=" + id +
            ", workerId=" + workerId +
            ", workerName=" + workerName +
            ", idNumber=" + idNumber +
            ", gender=" + gender +
            ", age=" + age +
            ", phoneNum=" + phoneNum +
            ", insuranceStartDate=" + insuranceStartDate +
            ", insuranceEndDate=" + insuranceEndDate +
            ", insuranceAmount=" + insuranceAmount +
            ", nation=" + nation +
            ", remarks=" + remarks +
            ", unitId=" + unitId +
            ", mainProjectId=" + mainProjectId +
            ", validFlag=" + validFlag +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
        "}";
    }
}
