package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.manager.BizEngineeringAccessoriesManager;
import com.artfess.yhxt.specialproject.model.BizEngineeringAccessories;
import com.artfess.yhxt.specialproject.model.BizProjectWeeklyMonthlyReport;
import com.artfess.yhxt.specialproject.model.BizProjectWeeklyMonthlyReport;
import com.artfess.yhxt.specialproject.model.BizProjectWeeklyMonthlyReport;
import com.artfess.yhxt.specialproject.dao.BizProjectWeeklyMonthlyReportDao;
import com.artfess.yhxt.specialproject.manager.BizProjectWeeklyMonthlyReportManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialproject.vo.BizProjectWeeklyMonthlyReportVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 项目周报月报表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-12
 */
@Service
public class BizProjectWeeklyMonthlyReportManagerImpl extends BaseManagerImpl<BizProjectWeeklyMonthlyReportDao, BizProjectWeeklyMonthlyReport> implements BizProjectWeeklyMonthlyReportManager {

    @Resource
    private BizEngineeringAccessoriesManager bizEngineeringAccessoriesManager;
    @Override
    public PageList<BizProjectWeeklyMonthlyReport> queryBizProjectWeeklyMonthlyReport(QueryFilter<BizProjectWeeklyMonthlyReport> queryFilter) {
        IPage<BizProjectWeeklyMonthlyReport> result =  baseMapper.queryBizProjectWeeklyMonthlyReport(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizProjectWeeklyMonthlyReport getBizProjectWeeklyMonthlyReportById(String id) {
        BizProjectWeeklyMonthlyReport bizProjectWeeklyMonthlyReport = baseMapper.selectById(id);
        return bizProjectWeeklyMonthlyReport;
    }

    @Override
    public void saveVo(BizProjectWeeklyMonthlyReportVo bizProjectWeeklyMonthlyReportVo) {
        //保存项目周报月报
        BizProjectWeeklyMonthlyReport bizProjectWeeklyMonthlyReport = bizProjectWeeklyMonthlyReportVo.getBizProjectWeeklyMonthlyReport();
        this.create(bizProjectWeeklyMonthlyReport);
        //附件
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizProjectWeeklyMonthlyReportVo.getBizEngineeringAccessoriesList();
        String sourceId = bizProjectWeeklyMonthlyReport.getId();
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public void updateVo(BizProjectWeeklyMonthlyReportVo bizProjectWeeklyMonthlyReportVo) {
        //修改项目周报月报
        BizProjectWeeklyMonthlyReport bizProjectWeeklyMonthlyReport = bizProjectWeeklyMonthlyReportVo.getBizProjectWeeklyMonthlyReport();
        this.update(bizProjectWeeklyMonthlyReport);
        String sourceId = bizProjectWeeklyMonthlyReport.getId();
        List<BizEngineeringAccessories> bizEngineeringAccessoriesList = bizProjectWeeklyMonthlyReportVo.getBizEngineeringAccessoriesList();
        bizEngineeringAccessoriesManager.removeEngineeringAccessories(sourceId);
        bizEngineeringAccessoriesList.forEach(s -> {
            s.setSourceId(sourceId);
            s.setValidFlag(1);
        });
        this.bizEngineeringAccessoriesManager.saveOrUpdateBatch(bizEngineeringAccessoriesList);
    }

    @Override
    public BizProjectWeeklyMonthlyReportVo getVo(String id) {
        BizProjectWeeklyMonthlyReportVo bizProjectWeeklyMonthlyReportVo= new BizProjectWeeklyMonthlyReportVo();
        BizProjectWeeklyMonthlyReport bizProjectWeeklyMonthlyReport = this.getById(id);
        List<BizEngineeringAccessories> engineeringAccessories = this.bizEngineeringAccessoriesManager.getEngineeringAccessoriesBySourceId(id);
        bizProjectWeeklyMonthlyReportVo.setBizProjectWeeklyMonthlyReport(bizProjectWeeklyMonthlyReport);
        bizProjectWeeklyMonthlyReportVo.setBizEngineeringAccessoriesList(engineeringAccessories);
        return bizProjectWeeklyMonthlyReportVo;
    }
}
