package com.artfess.yhxt.specialproject.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.specialproject.model.BizProjectCompletionApplicationForm;
import com.artfess.yhxt.specialproject.model.BizProjectCompletionApplicationForm;
import com.artfess.yhxt.specialproject.dao.BizProjectCompletionApplicationFormDao;
import com.artfess.yhxt.specialproject.manager.BizProjectCompletionApplicationFormManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialproject.model.BizProjectCompletionApplicationForm;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

/**
 * 工程竣工申请表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-11
 */
@Service
public class BizProjectCompletionApplicationFormManagerImpl extends BaseManagerImpl<BizProjectCompletionApplicationFormDao, BizProjectCompletionApplicationForm> implements BizProjectCompletionApplicationFormManager {

    @Override
    public PageList<BizProjectCompletionApplicationForm> queryBizProjectCompletionApplicationForm(QueryFilter<BizProjectCompletionApplicationForm> queryFilter) {
        IPage<BizProjectCompletionApplicationForm> result = baseMapper.queryBizProjectCompletionApplicationForm(convert2IPage(queryFilter.getPageBean()),convert2Wrapper(queryFilter,currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizProjectCompletionApplicationForm getBizProjectCompletionApplicationFormById(String id) {
        BizProjectCompletionApplicationForm bizProjectCompletionApplicationForm = baseMapper.selectById(id);
        return bizProjectCompletionApplicationForm;
    }
}
