package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialcheck.vo.BizMqiCheckDataVo;
import com.artfess.yhxt.specialproject.manager.BizEngineeringProjectManager;
import com.artfess.yhxt.specialproject.model.BizProjectContract;
import com.artfess.yhxt.specialproject.vo.BizProjectContractVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.model.BizProjectContract;
import com.artfess.yhxt.specialproject.manager.BizProjectContractManager;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 项目合同表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-10
 */
@RestController
@RequestMapping("/bizProjectContract/v1/")
@Api(tags = "项目合同管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizProjectContractController extends BaseController<BizProjectContractManager, BizProjectContract> {
    @Resource
    BizProjectContractManager bizProjectContractManager;

    @Resource
    private PermissionUtils permissionUtils;

    @Resource
    private BaseContext baseContext;

    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存项目合同信息", httpMethod = "POST", notes = "保存项目合同信息")
    public CommonResult<String> save(@ApiParam(name = "vo", value = "保存项目合同信息对象") @RequestBody BizProjectContractVo vo) throws Exception {
        this.baseService.saveBizProjectContractVo(vo);
        return new CommonResult<>(true, "保存成功");
    }

    @RequestMapping(value = "/getJson",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询项目合同信息",httpMethod ="POST")
    public PageList<BizProjectContract> getJson(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizProjectContract> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
//        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
//            queryFilter.addFilter("CREATE_ORG_ID_", String.join("','", baseContext.getCurrentOrgId()), QueryOP.IN, FieldRelation.AND);
//        }
        permissionUtils.addPermission(queryFilter);
        PageList<BizProjectContract> pageList = baseService.queryBizProjectContract(queryFilter);
        return pageList;
    }

    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询合同信息",httpMethod = "GET",notes = "根据ID查询桥梁专项检查信息")
    public BizProjectContractVo get(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getBizProjectContractById(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除项目合同信息",httpMethod = "DELETE",notes = "批量删除桥梁专项检查信息")
    public CommonResult<String> removes(@ApiParam(name = "ids",value = "对各主键用逗号分隔",required = true) @RequestParam String... ids) throws Exception{
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true,"删除成功");
    }

    @RequestMapping(value = "/updateContract",method = RequestMethod.DELETE,produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除项目合同信息",httpMethod = "DELETE",notes = "逻辑删除桥梁专项检查信息")
    public CommonResult<String> updateContract(@ApiParam(name = "ids",value = "ID集合以，隔开",required = true)
                                              @RequestParam(value = "ids",required = true)String ids)throws Exception{
        if (StringUtils.isNotBlank(ids)){
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizProjectContract> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_",idsList);
            updateWrapper.set("is_dele_","1");
            baseService.update(null,updateWrapper);
        }
        return new CommonResult<>(true,"删除成功");
    }

    @RequestMapping(value = "updateFlag", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量修改启用禁用状态", httpMethod = "POST", notes = "批量修改启用禁用状态")
    public CommonResult<String> updateFlag(@ApiParam(name = "ids", value = "Id集合，以,隔开") @RequestParam String ids,
                                           @ApiParam(name = "validFlag", value = "有效标志（0：无效  1：有效）") @RequestParam Integer flag) throws Exception {
        bizProjectContractManager.updateFlag(ids, flag);
        return new CommonResult<>(true, "状态修改成功");
    }
}
