package com.artfess.yhxt.specialcheck.vo;

import com.artfess.base.annotation.ExcelColumn;
import com.artfess.yhxt.specialcheck.model.BizMqiCheckDetail;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * @author zhx
 * @create 2022/3/3
 */
@Data
@ApiModel(value="MqiCheckDetail vo对象", description="mqi数据导入对象")
public class MqiCheckDetailVo {

    @ApiModelProperty(value = "方向值")
    @ExcelColumn(value = "directionValue", col = 0)
    private String directionValue;

    @ApiModelProperty(value = "起点桩号")
    @ExcelColumn(value = "startPeg", col = 1)
    private String startPeg;

    @ApiModelProperty(value = "结束桩号")
    @ExcelColumn(value = "endPeg", col = 2)
    private String endPeg;

    @ApiModelProperty(value = "MQI")
    @ExcelColumn(value = "mqiAvg", col = 4)
    private Float mqiAvg;


    @ApiModelProperty(value = "长度(m)")
    @ExcelColumn(value = "length", col = 3)
    private String length;



    @ApiModelProperty(value = "路基SCI")
    @ExcelColumn(value = "sciAvg", col = 5)
    private Float sciAvg;

    @ApiModelProperty(value = "路面PQI")
    @ExcelColumn(value = "pqiAvg", col = 6)
    private Float pqiAvg;



    @ApiModelProperty(value = "桥隧构造物BCI")
    @ExcelColumn(value = "bciAvg", col = 14)
    private Float bciAvg;

    @ApiModelProperty(value = "沿线设施TCI")
    @ExcelColumn(value = "tciAvg", col = 15)
    private Float tciAvg;



    @ApiModelProperty(value = "路面损坏PCI")
    @ExcelColumn(value = "pciAvg", col = 7)
    private Float pciAvg;

    @ApiModelProperty(value = "行驶质量RQI")
    @ExcelColumn(value = "rqiAvg", col = 8)
    private Float rqiAvg;

    @ApiModelProperty(value = "车辙深度RDI")
    @ExcelColumn(value = "rdiAvg", col = 9)
    private Float rdiAvg;

    @ApiModelProperty(value = "跳车PBI")
    @ExcelColumn(value = "pbiAvg", col = 10)
    private Float pbiAvg;

    @ApiModelProperty(value = "磨耗PWI")
    @ExcelColumn(value = "pwiAvg", col = 11)
    private Float pwiAvg;

    @ApiModelProperty(value = "抗滑性能SRI")
    @ExcelColumn(value = "sriAvg", col = 12)
    private Float sriAvg;

    @ApiModelProperty(value = "结构强度PSSI")
    @ExcelColumn(value = "pssiAvg", col = 13)
    private Float pssiAvg;


    @ApiModelProperty(value = "评定等级中文值")
    @ExcelColumn(value = "ratingValue", col = 16)
    private String ratingValue;

    public BizMqiCheckDetail getBizMqiCheckDetail(MqiCheckDetailVo vo){
        BizMqiCheckDetail bizMqiCheckDetail = new BizMqiCheckDetail();
        bizMqiCheckDetail.setDirectionValue(vo.getDirectionValue());
        bizMqiCheckDetail.setStartPeg(vo.getStartPeg());
        bizMqiCheckDetail.setEndPeg(vo.getEndPeg());
        bizMqiCheckDetail.setLength(vo.getLength());
        bizMqiCheckDetail.setMqiAvg(vo.getMqiAvg());
        bizMqiCheckDetail.setSciAvg(vo.getSciAvg());
        bizMqiCheckDetail.setPqiAvg(vo.getPqiAvg());
        bizMqiCheckDetail.setPciAvg(vo.getPciAvg());
        bizMqiCheckDetail.setRqiAvg(vo.getRqiAvg());
        bizMqiCheckDetail.setRdiAvg(vo.getRdiAvg());
        bizMqiCheckDetail.setPbiAvg(vo.getPbiAvg());
        bizMqiCheckDetail.setPwiAvg(vo.getPwiAvg());
        bizMqiCheckDetail.setSriAvg(vo.getSriAvg());
        bizMqiCheckDetail.setPssiAvg(vo.getPssiAvg());
        bizMqiCheckDetail.setBciAvg(vo.getBciAvg());
        bizMqiCheckDetail.setTciAvg(vo.getTciAvg());
        bizMqiCheckDetail.setRatingValue(vo.getRatingValue());
        return bizMqiCheckDetail;
    }
}
