package com.artfess.yhxt.specialcheck.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.User;
import com.artfess.yhxt.specialcheck.model.InspectionTaskConfig;
import com.artfess.yhxt.specialcheck.dao.InspectionTaskConfigDao;
import com.artfess.yhxt.specialcheck.manager.InspectionTaskConfigManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.yhxt.specialcheck.vo.InspectionTaskConfigVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import net.hasor.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 巡检任务-任务配置表 服务实现类
 *
 * @author xzh
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-08-26
 */
@Service
public class InspectionTaskConfigManagerImpl extends BaseManagerImpl<InspectionTaskConfigDao, InspectionTaskConfig> implements InspectionTaskConfigManager {

    @Resource
    private UserManager userManager;
    @Override
    public PageList<InspectionTaskConfigVo> queryInspectionTaskConfig(QueryFilter<InspectionTaskConfig> queryFilter) {
        HashMap<String, Object> map = new HashMap<>();
        Map<String, Object> params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<InspectionTaskConfigVo> results = baseMapper.queryInspectionTaskConfig(convert2IPage(queryFilter.getPageBean()), map, convert2Wrapper(queryFilter, currentModelClass()));
        List<InspectionTaskConfigVo> records = results.getRecords();
        for (InspectionTaskConfigVo record : records) {
            //巡检人ID RUMMAGER_ID_
            String rummagerId = record.getRummagerId();
            List<String> rummagerIds = Arrays.asList(rummagerId.split(","));
            QueryWrapper<User> userQueryWrapper = new QueryWrapper<>();
            userQueryWrapper.in("ID_",rummagerIds);
            List<User> users = userManager.getBaseMapper().selectList(userQueryWrapper);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < users.size(); i++) {
                User user = users.get(i);
                String fullname = user.getFullname();
                if (i==0) {
                    sb.append(fullname);
                }else {
                    sb.append(","+fullname);
                }
            }
            record.setRummagerName(sb.toString());
        }
        return new PageList<>(results);
    }

    @Override
    public InspectionTaskConfigVo getVo(String id) {
        InspectionTaskConfig inspectionTaskConfig = this.baseMapper.selectById(id);
        InspectionTaskConfigVo inspectionTaskConfigVo = new InspectionTaskConfigVo();
        BeanUtils.copyProperties(inspectionTaskConfigVo,inspectionTaskConfig);
        //巡检id
        String rummagerIds = inspectionTaskConfig.getRummagerId();
        List<String> ids = Arrays.asList(rummagerIds.split(","));
        StringBuffer sb = new StringBuffer();
        for (String rummagerId : ids) {
            String name = this.baseMapper.getRummagerName(rummagerId);
            sb.append(name).append(",");
        }
        String rummagerName = sb.deleteCharAt(sb.length() - 1).toString();

        inspectionTaskConfigVo.setRecorderName(rummagerName);
        return inspectionTaskConfigVo;
    }
}
