package com.artfess.yhxt.push.dao;

import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.push.vo.JV24EMPLOYEENEWVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @author zhx
 * @create 2021/10/19
 */
@Repository
public interface PushTaskMapper {
    //桥梁分类统计
    List<Map<String, Object>> getPushBrideCountType();

    //隧道类型
    List<Map<String, Object>> getPushTunnelCountType();

    //涵洞数量
    List<Map<String, Object>> getCulvertCount();

    //沿路设施收费站数量
    List<Map<String, Object>> getRoadsideFacilities();

    //路段
    List<Map<String, Object>> getRoadCount();

    /**
     * 查询桥梁信息  brg
     *
     * @return
     */
    List<Map<String, Object>> selectBrgList();

    //查询隧道信息 tunnel
    List<Map<String, Object>> selectTunnelList();

    //路段信息查询
    List<Map<String, Object>> selectRoadList();

    //服务区和收费站
    List<Map<String, Object>> selectAreaAndStatList();

    //路段信息查询
    List<Road> selectRoadInformationList();

    //查询病害信息
    List<Map<String, Object>> selectDiseaseList();

    Integer selectWorkOrderList(@Param("companyId") String companyId, @Param("accDate") String accDate);

    Integer selectProjectContractList(@Param("companyId") String companyId, @Param("accDate") String accDate);

    //年份查询病害分类
    List<Map<String, Object>> selectDiseaseTypeList();

    //月份查询病害分类
    List<Map<String, Object>> selectDiseaseTypeMouthList();

    //病害统计数据
    List<Map<String, Object>> diseaseCount();

    //查询养护工单已完成数量 - 年
    List<Map<String, Object>> selectWorkeCount();

    //    查询养护工单数量 - 年
    Map<String, Object> selectWorkeYearAllCount(@Param("companyId") String companyId, @Param("accDate") String accDate);

    //查询养护工单已完成数量 - 月
    List<Map<String, Object>> selectWorkeMonthCount();

    Map<String, Object> selectWorkeMonthAllCount(@Param("companyId") String companyId, @Param("accDate") String accDate);

    @Select("SELECT SUM(LENGTH_) FROM biz_road_section WHERE IS_DELE_ = 0")
    Integer RoadCountLength();

    List<Map<String, Object>> getUserCount();

    List<Map<String, Object>> selectConserveMoney();

    List<Map<String, Object>> selectSpecialMoney();

    List<Map<String, Object>> selectAvgDiseaseYear();

    List<Map<String, Object>> selectAvgDisease();

    List<Map<String, Object>> selectProjectProgressYear();

    List<Map<String, Object>> selectProjectProgress();

    List<Map<String, Object>> selectjv35ProjectTypeYear();

    List<Map<String, Object>> selectjv35ProjectType();

}
