package com.artfess.yhxt.disease.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.DataAccess;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.*;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.disease.vo.DiseaseReportVO;
import com.artfess.yhxt.push.service.PushTaskService;
import com.artfess.yhxt.statistics.vo.Org4DiseaseVO;
import com.artfess.yhxt.util.PermissionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.disease.model.Disease;
import com.artfess.yhxt.disease.manager.DiseaseManager;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

/**
 * 病害管理表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-09
 */
@RestController
@RequestMapping("/disease/v1/")
@Api(tags = "病害管理接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class DiseaseController extends BaseController<DiseaseManager, Disease> {



    @Resource
    private BaseContext baseContext;
    @Resource
    private RoadManager roadManager;
    @Resource
    private PermissionUtils permissionUtils;

    @RequestMapping(value = "diseaseReport", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取病害报表", httpMethod = "GET", notes = "获取病害报表")
    public List<DiseaseReportVO> diseaseReport(String year,String orgId) throws Exception {
        return baseService.diseaseReport(year,orgId);
    }

    @RequestMapping(value = "getDiseaseCountVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取病害数量", httpMethod = "POST", notes = "获取病害数量")
    public List<Org4DiseaseVO> getDiseaseCountVo(String year) throws Exception {
        return baseService.getDiseaseCount(year);
    }

    @RequestMapping(value="getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询病害信息",httpMethod = "POST")
    //@DataAccess("diseaseGetJson")
    public PageList<Disease> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<Disease> queryFilter) {
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermission(queryFilter);
            //queryFilter.addFilter("create_org_id_", String.join("','", baseContext.getCurrentOrgId()), QueryOP.IN, FieldRelation.AND);
        }
        return baseService.queryDisease(queryFilter);
    }


    @RequestMapping(value = "/saveDisease", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改病害信息", httpMethod = "POST")
    public CommonResult<String> saveDisease(@ApiParam(name = "disease", value = "病害对象") @RequestBody Disease disease) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(disease.getId())) {
            //计算病害超时日期
            disease.setDeadline(baseService.calculateDeadline(LocalDateTime.now()));
            //设置为未处理病害
            disease.setHandlingSituation(0);

            disease.setCreateAccount(baseContext.getCurrentUserAccout());
            baseService.create(disease);
        } else {
            baseService.update(disease);
            msg = "修改成功";
        }
        return new CommonResult<String>(true,msg,disease.getId());
    }

    @RequestMapping(value = "/save", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改病害、附件信息", httpMethod = "POST")
    public CommonResult<String> save(@ApiParam(name = "disease", value = "病害对象") @RequestBody Disease disease) throws Exception {
        String msg = "添加成功";

        if (StringUtils.isEmpty(disease.getId())) {
            if (disease.getCheckDate()==null){
                disease.setCheckDate(LocalDateTime.now());
            }
            //设置为未处理病害
            disease.setHandlingSituation(0);
            //计算病害超时日期
            disease.setDeadline(baseService.calculateDeadline(LocalDateTime.now()));
            disease.setCreateAccount(baseContext.getCurrentUserAccout());
            if (disease.getCompanyId()==null){
                Road road = roadManager.getById(disease.getRoadId());
                disease.setCompanyId(road.getCompanyId());
                disease.setCompanyName(road.getCompanyName());
            }
            baseService.saveDiseaseVo(disease);
        } else {
            baseService.updateDiseaseVo(disease);
            msg = "修改成功";
        }
        return new CommonResult<String>(true,msg,disease.getId());
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除病害信息", httpMethod = "DELETE", notes = "批量删除病害信息")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String ids) throws Exception {
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true, "删除成功");
    }

    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询病害信息", httpMethod = "GET", notes = "根据ID查询病害信息")
    public Disease get(@ApiParam(name = "id", value = "业务对象主键", required = true) @PathVariable String id) throws Exception {
//        return baseService.getById(id);
        return baseService.getByIdDisease(id);
    }

    @RequestMapping(value="getJsonBridgeDiseaseCheck",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询病害,桥梁定期经常信息",httpMethod = "POST")
    public PageList<Disease>  getJsonBridgeDiseaseCheck(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<Disease> queryFilter) throws Exception {
       // queryFilter.addFilter("a.BRIGE_ID_", queryFilter.getParams().get("BRIGE_ID_"), QueryOP.EQUAL);
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermission(queryFilter);
//            queryFilter.addFilter("create_org_id_", String.join("','", baseContext.getCurrentOrgId()), QueryOP.IN, FieldRelation.AND);
        }
        return baseService.getJsonBridgeDiseaseCheck(queryFilter);
    }


    @RequestMapping(value="getJsonCulvertDiseaseCheck",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询病害,涵洞定期经常信息",httpMethod = "POST")
    public PageList<Disease>  getJsonCulvertDiseaseCheck(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<Disease> queryFilter) throws Exception {
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermission(queryFilter);
//            queryFilter.addFilter("create_org_id_", String.join("','", baseContext.getCurrentOrgId()), QueryOP.IN, FieldRelation.AND);
        }
        return baseService.getJsonCulvertDiseaseCheck(queryFilter);
    }


    @RequestMapping(value="getJsonTunnelDiseaseCheck",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询病害,隧道定期经常信息",httpMethod = "POST")
    public PageList<Disease>  getJsonTunnelDiseaseCheck(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<Disease> queryFilter) throws Exception {
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermission(queryFilter);
//            queryFilter.addFilter("create_org_id_", String.join("','", baseContext.getCurrentOrgId()), QueryOP.IN, FieldRelation.AND);
        }
        return baseService.getJsonTunnelDiseaseCheck(queryFilter);
    }

    @RequestMapping(value="getJsonSideDiseaseCheck",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询病害,边坡定期经常信息",httpMethod = "POST")
    public PageList<Disease>  getJsonSideDiseaseCheck(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<Disease> queryFilter) throws Exception {
        if (StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermission(queryFilter);
//            queryFilter.addFilter("create_org_id_", String.join("','", baseContext.getCurrentOrgId()), QueryOP.IN, FieldRelation.AND);
        }
        return baseService.getJsonSideDiseaseCheck(queryFilter);
    }




    @PostMapping("/minioDrawingUpload")
    @ApiOperation(value = "病害图片上传接口")
   public Accessory minioDiseaseUpload(MultipartFile file, @ApiParam(name = "sourceId",value = "资源id",required = true) String sourceId){
        Accessory accessory = this.baseService.minioDiseaseUpload(file, sourceId);
        return accessory;
    }


    @DeleteMapping(value = "/removesDisease")
    @ApiOperation(value = "删除病害图片", httpMethod = "DELETE", notes = "删除病害图片")
    public CommonResult<String> minioDiseaseDel(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String ids) throws Exception {
        baseService.minioDiseaseDel(Arrays.asList(ids));
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping("/downloadDiseaseUpload")
    @ApiOperation(value = "病害图片下载接口", httpMethod = "POST", notes = "病害图片下载接口")
    public void downloadContractUpload( @ApiParam(name = "ids", value = "附件ID集合以，隔开")
                                        @RequestParam(value = "ids", required = true) String ids,
                                        HttpServletResponse response) throws Exception {
        this.baseService.minIoDiseaseDownFile(ids,response);

    }

    @Resource
    private PushTaskService pushTaskService;


    @GetMapping(value = "diseaseCount")
    @ApiOperation(value = "根据ID查询病害信息", httpMethod = "GET", notes = "根据ID查询病害信息")
    public void diseaseCount() throws Exception {
//        return baseService.getById(id);
         pushTaskService.diseaseCount();
    }


}
