package com.artfess.yhxt.contract.controller;

import cn.hutool.core.date.DateUtil;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.yhxt.contract.manager.WorkOrderExportManager;
import com.artfess.yhxt.contract.vo.WorkOrderParamVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;

/**
 * @author zhx
 * @create 2022/6/7
 */
@RestController
@RequestMapping("/workOrder/export/v1/")
@Api(tags = "工单导出")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class WorkOrderExportController {

    @Resource
    private WorkOrderExportManager workOrderExportManager;
    @RequestMapping(value = "exportWorkOrders", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "工程(中期计量、完工结算)清单表", httpMethod = "POST", notes = "工程(中期计量、完工结算)清单表")
    public void exportWorkOrders(@RequestBody @Validated WorkOrderParamVo param,
                                 HttpServletResponse response) throws Exception {
        workOrderExportManager.exportWorkOrders(param, response);

    }


     @RequestMapping(value = "exportWorkOrdersConstruction", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "工程(中期计量、完工结算)清单表-已办工单", httpMethod = "POST", notes = "工程(中期计量、完工结算)清单表")
    public void exportWorkOrdersConstruction(@RequestBody @Validated WorkOrderParamVo param,
                                 HttpServletResponse response) throws Exception {
        workOrderExportManager.exportWorkOrdersConstruction(param, response);

    }













    @RequestMapping(value = "exportWorkOrdersQuantities", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "工程量汇总表", httpMethod = "POST", notes = "工程量汇总表")
    public void exportWorkOrdersQuantities (@RequestBody @Validated WorkOrderParamVo param,
                                 HttpServletResponse response) throws Exception {

       workOrderExportManager.exportWorkOrdersQuantities(param, response);
    }


    @RequestMapping(value = "exportWorkOrdersQuantitiesConstruction", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "工程量汇总表-已办清单", httpMethod = "POST", notes = "工程量汇总表")
    public void exportWorkOrdersQuantitiesConstruction (@RequestBody @Validated WorkOrderParamVo param,
                                 HttpServletResponse response) throws Exception {

       workOrderExportManager.exportWorkOrdersQuantitiesConstruction(param, response);
    }



    @RequestMapping(value = "exportWorkOrdersDebitRecord", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "工程收方记录表（施工类）", httpMethod = "POST", notes = "工程收方记录表（施工类）")
    public void exportWorkOrdersDebitRecord (@RequestBody @Validated WorkOrderParamVo param,
                                            HttpServletResponse response) throws Exception {

        workOrderExportManager.exportWorkOrdersDebitRecord(param, response);
    }



    @RequestMapping(value = "exportWorkOrdersDebitRecordConstruction", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "工程收方记录表（施工类）-已办清单", httpMethod = "POST", notes = "工程收方记录表（施工类）")
    public void exportWorkOrdersDebitRecordConstruction (@RequestBody @Validated WorkOrderParamVo param,
                                            HttpServletResponse response) throws Exception {

        workOrderExportManager.exportWorkOrdersDebitRecordConstruction(param, response);
    }
}
