package com.artfess.yhxt.check.regular.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.check.regular.model.BridgeRegularCheck;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.check.regular.vo.BridgeRegularCheckFjVo;
import com.artfess.yhxt.check.regular.vo.BridgeRegularCheckVo;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 桥梁定期检查表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-16
 */
public interface BridgeRegularCheckManager extends BaseManager<BridgeRegularCheck> {

    PageList<BridgeRegularCheck> queryBridgeRegularCheck(QueryFilter<BridgeRegularCheck> queryFilter);


    void saveBridgeRegularCheck(BridgeRegularCheckVo vo);

    void updateBridgeRegularCheck(BridgeRegularCheckFjVo vo);

    BridgeRegularCheckVo getBridgeRegularCheckById(String id);

    Accessory minioRegularCheckUpload(MultipartFile file, String sourceId);

    void minioRegularCheck(List<String> asList);

    void downloadRegularCheckUpload(String ids, HttpServletResponse response) throws Exception;

    void importExcelData(MultipartFile file, BridgeRegularCheck parseObject);

    /**
     * 包含附件
     * @param vo
     */
    void saveBridgeRegularFjCheck(BridgeRegularCheckFjVo vo);

}
