package com.artfess.yhxt.check.regular.dao;


import com.artfess.yhxt.check.regular.model.BridgeOftenCheck;
import com.artfess.yhxt.check.regular.vo.BridgeOftenCheckVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;

import java.util.Map;

/**
 * 桥梁经常检查表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-08-03
 */
public interface BridgeOftenCheckDao extends BaseMapper<BridgeOftenCheck> {

    IPage<BridgeOftenCheck> queryBridgeOftenCheck(IPage<BridgeOftenCheck> convert2IPage,
                                                    @Param("map") Map<String, Object> params,
                                                    @Param(Constants.WRAPPER) Wrapper<BridgeOftenCheck> convert2Wrapper);

    @Select("SELECT * FROM BIZ_BRIDGE_OFTEN_CHECK  WHERE BRIGE_ID_ = #{id}   ORDER BY CHECK_DATE_ DESC LIMIT 0,1 ")
    BridgeOftenCheck selectMax(String id);


    Integer countBridgeOften(@Param("ids") String ids, @Param("mouth") String mouth);
}
