package com.artfess.yhxt.businessdata.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.businessdata.dao.CompanyDao;
import com.artfess.yhxt.businessdata.vo.CompanyVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.businessdata.model.Company;
import com.artfess.yhxt.businessdata.manager.CompanyManager;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * 养护单位 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-05
 */
@RestController
@RequestMapping("/Company/v1/")
@Api(tags = "养护单位管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class CompanyController extends BaseController<CompanyManager, Company> {




    /**
     * 养护单位管理列表(分页条件查询)数据
     *
     * @param queryFilter
     * @return
     * @throws Exception PageJson
     * @throws
     */
    @PostMapping("/list")
    @ApiOperation(value = "养护单位管理数据列表", httpMethod = "POST", notes = "获取养护单位管理列表")
    public PageList<Company> list(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<Company> queryFilter) throws Exception {
        return baseService.query(queryFilter);
    }

    /**
     * 养护单位管理明细页面
     *
     * @param id
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/get/{id}")
    @ApiOperation(value = "养护单位管理数据详情", httpMethod = "GET", notes = "养护单位管理数据详情")
    public Company get(@ApiParam(name = "id", value = "业务对象主键", required = true) @PathVariable String id) throws Exception {
        return baseService.get(id);
    }

    /**
     * 新增养护单位管理
     *
     * @param company
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "/save")
    @ApiOperation(value = "新增,更新养护单位管理数据", httpMethod = "POST", notes = "新增,更新养护单位管理数据")
    public CommonResult<String> save(@ApiParam(name = "Company", value = "养护单位管理业务对象", required = true) @RequestBody Company company) throws Exception {
        String msg = "添加养护单位管理成功";
        if (StringUtil.isEmpty(String.valueOf(company.getId()))) {

            baseService.saveCompany(company);
        } else {
            baseService.updateCompany(company);
            msg = "更新养护单位管理成功";
        }
        return new CommonResult<String>(msg);
    }

    /**
     * 删除养护单位管理记录
     *
     * @param id
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/remove/{id}")
    @ApiOperation(value = "删除养护单位管理记录", httpMethod = "DELETE", notes = "删除养护单位管理记录")
    public CommonResult<String> remove(@ApiParam(name = "id", value = "业务主键", required = true) @PathVariable String id) throws Exception {
        baseService.remove(id);
        return new CommonResult<String>(true, "删除成功");
    }

    /**
     * 批量删除养护单位管理记录
     *
     * @param ids
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除养护单位管理记录", httpMethod = "DELETE", notes = "批量删除养护单位管理记录")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String ids,@RequestParam String code) throws Exception {
        baseService.removeCompanyByIds(Arrays.asList(ids),code);
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping(value="/getList",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "不分页查询养护单位明细信息",httpMethod = "POST")
    public PageList<Company> getList(@ApiParam(name="queryFilter", value="不分页查询信息") @RequestBody QueryFilter<Company> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE);
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        PageList<Company>   road = baseService.queryCompany(queryFilter);
        return road;
    }

    @RequestMapping(value="/getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询养护单位明细信息",httpMethod = "POST")
    public PageList<Company> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<Company> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<Company> pageList = baseService.queryCompany(queryFilter);
        return  pageList;
    }

    @RequestMapping(value="/getTree/{demId}", produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "查询养护单位",httpMethod = "POST")
    public List<CompanyVo> getTree(@ApiParam(name = "demId", value = "维度ID", required = true) @PathVariable String demId,
                                   @ApiParam(name = "grades", value = "需要禁用级别编码集合", required = false) @RequestBody List<String> grades) throws Exception{

        return  baseService.getTree(demId, grades);
    }


    @RequestMapping(value="/getTree/company/{demId}",method = RequestMethod.GET, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "查询公司",httpMethod = "GET")
    public List<CompanyVo> getTreeCompany(@ApiParam(name = "demId", value = "维度ID", required = true) @PathVariable String demId) throws Exception{
        return  baseService.getTreeCompany(demId);
    }

    @RequestMapping(value="/getTree/Newcompany/{demId}",method = RequestMethod.GET, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "查询公司统计报表模块",httpMethod = "GET")
    public List<CompanyVo> getTreeNewCompany(@ApiParam(name = "demId", value = "维度ID", required = true) @PathVariable String demId) throws Exception{
        return  baseService.getTreeNewCompany(demId);
    }



    @RequestMapping(value="/getCompany", produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "根据登录人查询公司",httpMethod = "POST")
    public List<Org> getCompany(@ApiParam(name="queryFilter", value="查询信息") @RequestBody QueryFilter queryFilter) throws Exception{
        return baseService.getCompany(queryFilter);
    }
/*    @RequestMapping(value="/getCompanyT", produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "根据登录人查询公司测试",httpMethod = "POST")
    public List<Org> getCompanyT(@ApiParam(name="queryFilter", value="查询信息") @RequestBody QueryFilter queryFilter) throws Exception{
        return baseService.getCompany();
    }*/


/*    @RequestMapping(value = "updateBatchList", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量逻辑删除", httpMethod = "POST", notes = "批量逻辑删除")
    public CommonResult<String> updateBatchList(
            @ApiParam(name = "ids", value = "养护单位ID集合以，隔开", required = true)
            @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<Company> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);

        }

        return new CommonResult<>(true, "批量删除成功");
    }*/

}
