package com.artfess.yhxt.basedata.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 施工人员管理表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-10-12
 */
@ApiModel(value="BizMigrantBuildersInformation对象", description="施工人员管理表")
@TableName("BIZ_MIGRANT_BUILDERS_INFORMATION")
public class MigrantBuildersInformation extends BizModel<MigrantBuildersInformation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "业务主键id")
    @TableField("WORKER_ID_")
    private String workerId;

    @ApiModelProperty(value = "工人姓名")
    @TableField("WORKER_NAME_")
    private String workerName;

    @ApiModelProperty(value = "身份证号码")
    @TableField("ID_NUMBER_")
    private String idNumber;

    @ApiModelProperty(value = "性别")
    @TableField("GENDER_")
    private String gender;

    @ApiModelProperty(value = "年龄")
    @TableField("AGE_")
    private Integer age;

    @ApiModelProperty(value = "手机号码")
    @TableField("PHONE_NUM_")
    private String phoneNum;

    @ApiModelProperty(value = "保险生效时间")
    @TableField("INSURANCE_START_DATE_")
    private String insuranceStartDate;

    @ApiModelProperty(value = "保险到期时间")
    @TableField("INSURANCE_END_DATE_")
    private String insuranceEndDate;

    @ApiModelProperty(value = "保额")
    @TableField("INSURANCE_AMOUNT_")
    private String insuranceAmount;

    @ApiModelProperty(value = "民族")
    @TableField("NATION_")
    private String nation;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "所属单位")
    @TableField("UNIT_ID_")
    private String unitId;

    @ApiModelProperty(value = "1-有效（默认值）、0-无效")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

//    @ApiModelProperty(value = "创建人ID")
//    @TableField("CREATE_BY_")
//    private String createBy;
//
//    @ApiModelProperty(value = "创建人姓名")
//    @TableField("CREATE_NAME_")
//    private String createName;
//
//    @ApiModelProperty(value = "创建人组织ID")
//    @TableField("CREATE_ORG_ID_")
//    private String createOrgId;
//
//    @ApiModelProperty(value = "创建人组织名称")
//    @TableField("CREATE_ORG_NAME_")
//    private String createOrgName;
//
//    @ApiModelProperty(value = "创建人单位ID")
//    @TableField("CREATE_COMPANY_ID_")
//    private String createCompanyId;
//
//    @ApiModelProperty(value = "创建人单位名称")
//    @TableField("CREATE_COMPANY_NAME_")
//    private String createCompanyName;
//
//    @ApiModelProperty(value = "创建时间")
//    @TableField("CREATE_TIME_")
//    private LocalDateTime createTime;
//
//    @ApiModelProperty(value = "更新人ID")
//    @TableField("UPDATE_BY_")
//    private String updateBy;
//
//    @ApiModelProperty(value = "更新人姓名")
//    @TableField("UPDATE_NAME_")
//    private String updateName;
//
//    @ApiModelProperty(value = "更新人单位名称")
//    @TableField("UPDATE_COMPANY_NAME_")
//    private String updateCompanyName;
//
//    @ApiModelProperty(value = "更新人单位ID")
//    @TableField("UPDATE_COMPANY_ID_")
//    private String updateCompanyId;
//
//    @ApiModelProperty(value = "更新人组织ID")
//    @TableField("UPDATE_ORG_ID_")
//    private String updateOrgId;
//
//    @ApiModelProperty(value = "更新人组织名称")
//    @TableField("UPDATE_ORG_NAME_")
//    private String updateOrgName;
//
//    @ApiModelProperty(value = "更新时间")
//    @TableField("UPDATE_TIME_")
//    private LocalDateTime updateTime;
//
//    @ApiModelProperty(value = "最后更新时间戳")
//    @TableField("LAST_TIME_")
//    private Long lastTime;
//
//    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
//    @TableField("IS_DELE_")
//    private String isDele;
//
//    @ApiModelProperty(value = "版本号")
//    @TableField("VERSION_")
//    private Long version;
//
//    @ApiModelProperty(value = "租户ID")
//    @TableField("TENANT_ID_")
//    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getWorkerId() {
        return workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }
    public String getWorkerName() {
        return workerName;
    }

    public void setWorkerName(String workerName) {
        this.workerName = workerName;
    }
    public String getIdNumber() {
        return idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }
    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }
    public Integer getAge() {
        return age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }
    public String getPhoneNum() {
        return phoneNum;
    }

    public void setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
    }
    public String getInsuranceStartDate() {
        return insuranceStartDate;
    }

    public void setInsuranceStartDate(String insuranceStartDate) {
        this.insuranceStartDate = insuranceStartDate;
    }
    public String getInsuranceEndDate() {
        return insuranceEndDate;
    }

    public void setInsuranceEndDate(String insuranceEndDate) {
        this.insuranceEndDate = insuranceEndDate;
    }
    public String getInsuranceAmount() {
        return insuranceAmount;
    }

    public void setInsuranceAmount(String insuranceAmount) {
        this.insuranceAmount = insuranceAmount;
    }
    public String getNation() {
        return nation;
    }

    public void setNation(String nation) {
        this.nation = nation;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public String getUnitId() {
        return unitId;
    }

    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }
    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
//    public String getCreateBy() {
//        return createBy;
//    }
//
//    public void setCreateBy(String createBy) {
//        this.createBy = createBy;
//    }
//    public String getCreateName() {
//        return createName;
//    }
//
//    public void setCreateName(String createName) {
//        this.createName = createName;
//    }
//    public String getCreateOrgId() {
//        return createOrgId;
//    }
//
//    public void setCreateOrgId(String createOrgId) {
//        this.createOrgId = createOrgId;
//    }
//    public String getCreateOrgName() {
//        return createOrgName;
//    }
//
//    public void setCreateOrgName(String createOrgName) {
//        this.createOrgName = createOrgName;
//    }
//    public String getCreateCompanyId() {
//        return createCompanyId;
//    }
//
//    public void setCreateCompanyId(String createCompanyId) {
//        this.createCompanyId = createCompanyId;
//    }
//    public String getCreateCompanyName() {
//        return createCompanyName;
//    }
//
//    public void setCreateCompanyName(String createCompanyName) {
//        this.createCompanyName = createCompanyName;
//    }
//    public LocalDateTime getCreateTime() {
//        return createTime;
//    }
//
//    public void setCreateTime(LocalDateTime createTime) {
//        this.createTime = createTime;
//    }
//    public String getUpdateBy() {
//        return updateBy;
//    }
//
//    public void setUpdateBy(String updateBy) {
//        this.updateBy = updateBy;
//    }
//    public String getUpdateName() {
//        return updateName;
//    }
//
//    public void setUpdateName(String updateName) {
//        this.updateName = updateName;
//    }
//    public String getUpdateCompanyName() {
//        return updateCompanyName;
//    }
//
//    public void setUpdateCompanyName(String updateCompanyName) {
//        this.updateCompanyName = updateCompanyName;
//    }
//    public String getUpdateCompanyId() {
//        return updateCompanyId;
//    }
//
//    public void setUpdateCompanyId(String updateCompanyId) {
//        this.updateCompanyId = updateCompanyId;
//    }
//    public String getUpdateOrgId() {
//        return updateOrgId;
//    }
//
//    public void setUpdateOrgId(String updateOrgId) {
//        this.updateOrgId = updateOrgId;
//    }
//    public String getUpdateOrgName() {
//        return updateOrgName;
//    }
//
//    public void setUpdateOrgName(String updateOrgName) {
//        this.updateOrgName = updateOrgName;
//    }
//    public LocalDateTime getUpdateTime() {
//        return updateTime;
//    }
//
//    public void setUpdateTime(LocalDateTime updateTime) {
//        this.updateTime = updateTime;
//    }
//    public Long getLastTime() {
//        return lastTime;
//    }
//
//    public void setLastTime(Long lastTime) {
//        this.lastTime = lastTime;
//    }
//    public String getIsDele() {
//        return isDele;
//    }
//
//    public void setIsDele(String isDele) {
//        this.isDele = isDele;
//    }
//    public Long getVersion() {
//        return version;
//    }
//
//    public void setVersion(Long version) {
//        this.version = version;
//    }
//    public String getTenantId() {
//        return tenantId;
//    }
//
//    public void setTenantId(String tenantId) {
//        this.tenantId = tenantId;
//    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizMigrantBuildersInformation{" +
            "id=" + id +
            ", workerId=" + workerId +
            ", workerName=" + workerName +
            ", idNumber=" + idNumber +
            ", gender=" + gender +
            ", age=" + age +
            ", phoneNum=" + phoneNum +
            ", insuranceStartDate=" + insuranceStartDate +
            ", insuranceEndDate=" + insuranceEndDate +
            ", insuranceAmount=" + insuranceAmount +
            ", nation=" + nation +
            ", remarks=" + remarks +
            ", unitId=" + unitId +
            ", validFlag=" + validFlag +
            ", companyId=" + companyId +
            ", companyName=" + companyName +
//            ", createBy=" + createBy +
//            ", createName=" + createName +
//            ", createOrgId=" + createOrgId +
//            ", createOrgName=" + createOrgName +
//            ", createCompanyId=" + createCompanyId +
//            ", createCompanyName=" + createCompanyName +
//            ", createTime=" + createTime +
//            ", updateBy=" + updateBy +
//            ", updateName=" + updateName +
//            ", updateCompanyName=" + updateCompanyName +
//            ", updateCompanyId=" + updateCompanyId +
//            ", updateOrgId=" + updateOrgId +
//            ", updateOrgName=" + updateOrgName +
//            ", updateTime=" + updateTime +
//            ", lastTime=" + lastTime +
//            ", isDele=" + isDele +
//            ", version=" + version +
//            ", tenantId=" + tenantId +
        "}";
    }
}
