package com.artfess.yhxt.basedata.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.model.BizRoadIndexCode;
import com.artfess.yhxt.basedata.model.BizVehicle;
import com.artfess.base.manager.BaseManager;
import com.artfess.yhxt.basedata.vo.BizRoadIndexCodeVO;
import com.artfess.yhxt.basedata.vo.OrgVehicleNumVo;
import com.artfess.yhxt.basedata.vo.VehicleCountVo;
import com.artfess.yhxt.statistics.vo.Org4RescueVO;
import com.artfess.yhxt.statistics.vo.VehicleVO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 养护车辆管理 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-05
 */
public interface BizVehicleManager extends BaseManager<BizVehicle> {
    /**
     * @Description: 不分页查询车辆
     * @Param: sysActuator
     * @Return: java.util.List<com.artfess.portal.model.SysActuator>
     * @Author: wp
     * @Date: 2021/7/15
     */
    PageList<BizVehicle> queryBizVehicle(QueryFilter<BizVehicle> queryFilter);

    String minioDrawingUpload(MultipartFile file);


    void minioDrawingDelete(String url);

    Boolean synchronizationCarData();

    List<BizRoadIndexCodeVO> findAll();

//    List<VehicleVO> getVehicleCount();


    List<VehicleCountVo> getVehicleCountVo();


}
