package com.artfess.yhxt.basedata.dao;

import com.artfess.yhxt.basedata.model.BridgeInformation;
import com.artfess.yhxt.basedata.vo.BridgeCheckVo;
import com.artfess.yhxt.basedata.vo.BridgeRegularVo;
import com.artfess.yhxt.check.regular.model.BridgeRegularCheck;
import com.artfess.yhxt.check.regular.vo.BridgeRegularCheckVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.Map;

/**
 * 桥梁信息表 Mapper 接口
 *
 * @author 向贞好
 * @company 阿特菲斯信息技术有限公司
 * @since 2021-07-27
 */
public interface BridgeInformationDao extends BaseMapper<BridgeInformation> {

    //桥梁经常检查
    IPage<BridgeCheckVo> getBridgeInformation(IPage<BridgeInformation> convert2IPage,
                                              @Param("map") Map<String, Object> params,
                                              @Param(Constants.WRAPPER) Wrapper<BridgeInformation> convert2Wrapper);

    void setXY(String id);

    IPage<BridgeInformation> queryBridgeInformation(IPage<BridgeInformation> convert2IPage,@Param("map") Map<String, Object> params, @Param(Constants.WRAPPER) Wrapper<BridgeInformation> convert2Wrapper);

    //定期检查 根据查询系统参数计算下次检查日期和当前时间做对比
    IPage<BridgeRegularVo> queryBridgeRegularCheckVo(IPage<BridgeInformation> convert2IPage, @Param("map") Map<String, Object> params,
                                                     @Param(Constants.WRAPPER) Wrapper<BridgeInformation> convert2Wrapper);
}
