package com.artfess.yhxt.basedata.dao;

import com.artfess.yhxt.basedata.model.BizCourseDetails;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 科目明细表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-07-30
 */
public interface BizCourseDetailsDao extends BaseMapper<BizCourseDetails> {
    /**
     * 根据父组织id获取其下子组织（包含父组织）
     * @param
     * @return
     */
    List<BizCourseDetails> getByParentId(@Param("pcode") String pCode);

    IPage<BizCourseDetails> getBizCourseDetails(IPage<BizCourseDetails> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BizCourseDetails> convert2Wrapper);

    int bizCourseDetails(String pCode);

}
