package com.artfess.yhxt.basedata.controller;


import com.artfess.yhxt.basedata.manager.TunnelInformationManager;
import com.artfess.yhxt.basedata.model.TunnelInformation;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.basedata.vo.TunnelCheckVo;
import com.artfess.yhxt.basedata.vo.TunnelRegularVo;
import com.artfess.yhxt.statistics.vo.Org4tunnelVO;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;


/**
 * 隧道信息表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-07-28
 */
@RestController
@RequestMapping("/bizTunnelInformation/v1/")
@Api(tags = "隧道管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class TunnelInformationController extends BaseController<TunnelInformationManager, TunnelInformation> {


    @RequestMapping(value = "getTunnelVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取隧道统计", httpMethod = "POST", notes = "获取隧道统计")
    public List<Org4tunnelVO> getTunnelVo() throws Exception {
        return baseService.getTunnelCount();
    }
    
    @RequestMapping(value = "/saveTunnel", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改隧道信息", httpMethod = "POST")
    public CommonResult<String> saveTunnel(@ApiParam(name = "tunnelInformation", value = "隧道对象") @RequestBody TunnelInformation tunnelInformation) throws Exception {
        String msg = "添加成功";
        //this.baseService.checkNumber(tunnelInformation);
        if (StringUtils.isEmpty(tunnelInformation.getId())) {
            tunnelInformation.setIsDele("0");
            tunnelInformation.setSn(baseService.getSn());
            baseService.saveTunnel(tunnelInformation);
        } else {
            baseService.updateTunnel(tunnelInformation);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }


//    @RequestMapping(value="/getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
//    @ApiOperation(value = "分页查询隧道信息",httpMethod = "POST")
//    public PageList<TunnelInformationVo> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<TunnelInformation> queryFilter) {
//        IPage<TunnelInformationVo> bridgeInformationVoIPage = baseService.queryTunnel(queryFilter);
//        return new PageList<TunnelInformationVo>(bridgeInformationVoIPage);
//    }

    @RequestMapping(value="/getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询隧道信息",httpMethod = "POST")
    public PageList<TunnelInformation> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<TunnelInformation> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<TunnelInformation> pageList = baseService.queryTunnelInformation(queryFilter);
        return pageList;
    }


    @RequestMapping(value = "/updateBySn", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改排序号", httpMethod = "POST")
    public CommonResult<String> updateBySn(@ApiParam(name = "params", value = "排序参数：Key：ID，Value：排序号") @RequestBody HashMap<String, Integer> params) throws Exception {
        baseService.updateSequence(params);
        return new CommonResult<>(true, "排序完成");
    }

    @GetMapping(value="get/{id}")
    @ApiOperation(value="根据ID查询隧道信息",httpMethod = "GET",notes = "根据ID查询隧道信息")
    public TunnelInformation get(@ApiParam(name="id",value="业务对象主键", required = true)@PathVariable String id) throws Exception{
        return baseService.getTunnelById(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除隧道信息", httpMethod = "DELETE", notes = "批量删除隧道信息")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping(value = "/updateBridge", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除隧道信息", httpMethod = "POST", notes = "逻辑删除隧道信息")
    public CommonResult<String> updateBridge(@ApiParam(name = "ids", value = "可视化分类ID集合以，隔开", required = true)
                                             @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<TunnelInformation> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);
        }
        return new CommonResult<>(true, "删除成功");
    }

    @RequestMapping(value="/getJsonVo",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询隧道经常检查信息",httpMethod = "POST")
    public PageList<TunnelCheckVo> getJsonVo(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<TunnelInformation> queryFilter) throws Exception {
        PageList<TunnelCheckVo> pageList = baseService.queryTunnel(queryFilter);
        return pageList;
    }

    @RequestMapping(value="/getJsonRegularVo",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询隧道定期检查信息",httpMethod = "POST")
    public PageList<TunnelRegularVo> getJsonRegularVo(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<TunnelInformation> queryFilter) throws Exception {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<TunnelRegularVo> pageList = baseService.queryTunnelRegular(queryFilter);
        return pageList;
    }
}
