package com.artfess.yhxt.basedata.controller;

import com.artfess.base.annotation.DataAccess;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.dao.RoadDao;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.yhxt.statistics.vo.Org4BridgeVO;
import com.artfess.yhxt.statistics.vo.Org4RoadVO;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 路段前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-07-30
 */
@RestController
@RequestMapping(value = "/road/roadmanage/v1")
@Api(tags = "路段管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class RoadController extends BaseController<RoadManager, Road> {

    @Resource
    private OrgManager orgManager;

    @RequestMapping(value = "getRoadCountVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取路段统计数量", httpMethod = "POST", notes = "获取路段统计数量")
    public List<Org4RoadVO> getRoadCountVo() throws Exception {
        return baseService.getRoadCount();
    }


    @GetMapping("/getZSId")
    @ApiOperation(value = "招商跳转转换", httpMethod = "GET", notes = "招商跳转转换")
    public List<String> list(String code) {
        QueryWrapper<Org> wrapper = new QueryWrapper<>();
        wrapper.eq("is_dele_","0");
        wrapper.eq("zs_code_",code);
        wrapper.last("limit 1");
        Org org = orgManager.getOne(wrapper);
        Set<String> pid = new HashSet<>();
        pid.add(org.getId());
        List<String> ids = orgManager.getSubOrgByIds(pid);
        ids.add(org.getId());
        return ids;
    }


    /**
     * 路段管理列表(分页条件查询)数据
     *
     * @param queryFilter
     * @return
     * @throws Exception PageJson
     * @throws
     */
    @PostMapping("/list")
    @ApiOperation(value = "路段管理数据列表", httpMethod = "POST", notes = "获取路段管理列表")

    public PageList<Road> list(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<Road> queryFilter) throws Exception {
        return baseService.query(queryFilter);
    }

    /**
     * 路段管理明细页面
     *
     * @param id
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/get/{id}")
    @ApiOperation(value = "路段管理数据详情", httpMethod = "GET", notes = "路段管理数据详情")
    public Road get(@ApiParam(name = "id", value = "业务对象主键", required = true) @PathVariable String id) throws Exception {
        return baseService.get(id);
    }

    /**
     * 新增路段管理
     *
     * @param Road
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "/save")
    @ApiOperation(value = "新增,更新路段管理数据", httpMethod = "POST", notes = "新增,更新路段管理数据")
    public CommonResult<String> save(@ApiParam(name = "Road", value = "路段管理业务对象", required = true) @RequestBody Road Road) throws Exception {
        String msg = "添加路段管理成功";
        if (StringUtil.isEmpty(Road.getId())) {
            Road.setIsDele("0");
            HashMap<String, Object> map = new HashMap<>();
            IUser user= ContextUtil.getCurrentUser();
            if(ObjectUtils.isNotEmpty(user)){
                map.put("tenant_id_", user.getTenantId());
            }
            int nextSequence =baseService.getNextSequence(map);
            Road.setSn(nextSequence);
            baseService.create(Road);
        } else {
            baseService.update(Road);
            msg = "更新路段管理成功";
        }
        return new CommonResult<String>(msg);
    }

    /**
     * 删除路段管理记录
     *
     * @param id
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/remove/{id}")
    @ApiOperation(value = "删除路段管理记录", httpMethod = "DELETE", notes = "删除路段管理记录")
    public CommonResult<String> remove(@ApiParam(name = "id", value = "业务主键", required = true) @PathVariable String id) throws Exception {
        baseService.remove(id);
        return new CommonResult<String>(true, "删除成功");
    }

    /**
     * 批量删除路段管理记录
     *
     * @param ids
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除路段管理记录", httpMethod = "DELETE", notes = "批量删除路段管理记录")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "多个主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true, "删除成功");
    }

    @RequestMapping(value="/getList",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "不分页查询路段信息",httpMethod = "POST")
    public PageList<Road> getList(@ApiParam(name="queryFilter", value="不分页查询信息") @RequestBody QueryFilter<Road> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE);
        pageBean.setPage(1);
        queryFilter.setPageBean(pageBean);
        PageList<Road>   road = baseService.queryRoad(queryFilter);
        return road;
    }

    @RequestMapping(value="/getJson",method = RequestMethod.POST, produces={"application/json; charset=utf-8" })
    @ApiOperation(value = "分页查询路段信息",httpMethod = "POST")
    //@DataAccess("roadGetJson")
    public PageList<Road> getJson(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<Road> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<Road> pageList = baseService.queryRoad(queryFilter);
        return  pageList;
    }

    @RequestMapping(value = "/updateBySn", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改排序号", httpMethod = "POST")
    public CommonResult<String> updateBySn(@ApiParam(name = "params", value = "排序参数：Key：ID，Value：排序号") @RequestBody HashMap<String, Integer> params) throws Exception {
        baseService.updateSequence(params);
        return new CommonResult<>(true, "排序完成");
    }

    @RequestMapping(value = "updateBatch", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "逻辑删除", httpMethod = "POST", notes = "逻辑删除")
    public CommonResult<String> updateBatchRoute(@ApiParam(name = "id", value = "路线ID", required = true) @RequestParam(value = "id", required = true) String id) throws Exception {

        if (StringUtils.isNotBlank(id))
            baseService.updateRoad(id);
        return new CommonResult<>(true, "删除成功");
    }

    @RequestMapping(value = "updateRoad", method = RequestMethod.DELETE, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量逻辑删除", httpMethod = "DELETE", notes = "批量逻辑删除")
    public CommonResult<String> updateRoad(
            @ApiParam(name = "ids", value = "路线ID集合以，隔开", required = true)
            @RequestParam(value = "ids", required = true) String ids) throws Exception {
        if (StringUtils.isNotBlank(ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<Road> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_", idsList);
            updateWrapper.set("is_dele_", "1");
            baseService.update(null, updateWrapper);

        }

        return new CommonResult<>(true, "批量删除成功");
    }

}
