package com.artfess.yhxt.specialproject.vo;

import com.artfess.yhxt.specialproject.model.BizProjectManageQuality;
import com.artfess.yhxt.specialproject.model.BizProjectManageQualityChange;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;


@Data
@ApiModel(value="BizProjectManageQualityChange vo对象", description="项目质量整改实体、项目质检单实体")
public class BizProjectManageQualityChangeVo {
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "质检单整改表id")
    @TableField("REFORM_ID_")
    private String reformId;

    @ApiModelProperty(value = "质检单表id")
    @TableField("TEST_ID_")
    private String testId;

    @ApiModelProperty(value = "整改序号")
    @TableField("REFORM_SEQ_")
    private Integer reformSeq;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "整改时间")
    @TableField("REFORM_DATE_")
    private LocalDate reformDate;

    @ApiModelProperty(value = "整改结果（1-已整改、0-未整改)")
    @TableField("REFORM_FLAG_")
    private Integer reformFlag;

    @ApiModelProperty(value = "整改结果描述")
    @TableField("REFORM_DESCRIPTION_")
    private String reformDescription;

    @ApiModelProperty(value = "整改施工方人员")
    @TableField("REFORM_USE_ID_")
    private String reformUseId;

    @ApiModelProperty(value = "整改施工方")
    @TableField("REFORM_DEPART_")
    private String reformDepart;

    @ApiModelProperty(value = "复查时间")
    @TableField("CONFIRM_DATE_")
    private LocalDate confirmDate;

    @ApiModelProperty(value = "复查结果（0-待复查、1-通过、2-不通过)")
    @TableField("CONFIRM_RESULT_")
    private Integer confirmResult;

    @ApiModelProperty(value = "复查结果描述")
    @TableField("CONFIRM_DESCRIPTION_")
    private String confirmDescription;

    @ApiModelProperty(value = "复查人（质检单表的testUser）")
    @TableField("CONFIRM_USER_ID_")
    private String confirmUserId;

    @ApiModelProperty(value = "1-有效（默认值）、0-无效")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;


    @ApiModelProperty(value = "工程表id")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "工程表name")
    @TableField("PROJECT_NAME_")
    private String projectName;


    @ApiModelProperty(value = "整改次数，默认值1")
    @TableField("REFORM_COUNT_")
    private Integer reformCount;


    @ApiModelProperty(value = "质检时间")
    @TableField("TEST_TIME_")
    private LocalDate testTime;

    @ApiModelProperty(value = "质检地点")
    @TableField("TEST_LOCATION_")
    private String testLocation;

    @ApiModelProperty(value = "质检员")
    @TableField("TEST_USER_ID_")
    private String testUserId;

    @ApiModelProperty(value = "质检员")
    @TableField("TEST_USER_NAME_")
    private String testUserName;

    @ApiModelProperty(value = "有无质检问题（1-有、0-无)、默认值0")
    @TableField("TEST_RESULT_")
    private Integer testResult;


}
