package com.artfess.yhxt.specialproject.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 专项工程-计量支付
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xmz
 * @since 2022-06-29
 */
@ApiModel(value="MeasurementPayment对象", description="专项工程-计量支付")
@TableName("biz_measurement_payment")
@Data
public class MeasurementPayment extends AutoFillModel<MeasurementPayment> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "公司ID选择路段进行带入")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "项目id")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "项目name")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "所在路段id(关联路段表ID)")
    @TableField("ROAD_SEGMENT_ID_")
    private String roadSegmentId;

    @ApiModelProperty(value = "所在路段NAME")
    @TableField("ROAD_SEGMENT_NAME_")
    private String roadSegmentName;

    @ApiModelProperty(value = "专项合同id")
    @TableField("PROJECT_CONTRACT_ID_")
    private String projectContractId;

    @ApiModelProperty(value = "专项合同名")
    @TableField("PROJECT_CONTRACT_NAME_")
    private String projectContractName;

    @ApiModelProperty(value = "支付期数 使用字典管理")
    @TableField("PAYMENT_PERIODS_")
    private String paymentPeriods;


    @ApiModelProperty(value = "支付日期")
    @TableField("PAYMENT_DATE_")
    private LocalDateTime paymentDates;



    @ApiModelProperty(value = "支付金额")
    @TableField("PAYMENT_CASHS_")
    private BigDecimal paymentCashs;

    @ApiModelProperty(value = "支付比例")
    @TableField("PAYMENT_SCALE_")
    private BigDecimal paymentScale;



    @ApiModelProperty(value = "施工表-表格编号")
    @TableField("RECORD_NUMBER_")
    private String recordNumber;

    @ApiModelProperty(value = "汇总表-表格编号")
    @TableField("SUMMARY_NUMBER_")
    private String summaryNumber;


}
