package com.artfess.yhxt.specialproject.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.yhxt.specialproject.model.BizProjectContractDetails;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.specialproject.model.BizProjectContractDetails;
import com.artfess.yhxt.specialproject.manager.BizProjectContractDetailsManager;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * 项目合同明细表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wangping
 * @since 2021-08-10
 */
@RestController
@RequestMapping("/bizProjectContractDetails/v1/")
@Api(tags = "项目合同明细管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizProjectContractDetailsController extends BaseController<BizProjectContractDetailsManager, BizProjectContractDetails> {
    @Resource
    private PermissionUtils permissionUtils;

    @Resource
    private BaseContext baseContext;

    @RequestMapping(value = "/saveProjectContractDetails",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改项目合同明细检查信息",httpMethod = "POST")
    public CommonResult<String> saveEngineeringProject(@ApiParam(name = "bizProjectContractDetails",value = "项目合同明细专项检查对象") @RequestBody BizProjectContractDetails bizProjectContractDetails) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(bizProjectContractDetails.getId())){
            bizProjectContractDetails.setIsDele("0");
            baseService.create(bizProjectContractDetails);
        }else {
            baseService.update(bizProjectContractDetails);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value = "getJson",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询项目合同明细信息",httpMethod ="POST")
    public PageList<BizProjectContractDetails> getJson(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<BizProjectContractDetails> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(baseContext.getCurrentOrgId()) ){
            permissionUtils.addPermissionByCreateOrgId(queryFilter);
        }
        PageList<BizProjectContractDetails> pageList = baseService.queryBizProjectContractDetails(queryFilter);
        return pageList;
    }

    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询桥梁专项检查信息",httpMethod = "GET",notes = "根据ID查询桥梁专项检查信息")
    public BizProjectContractDetails get(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        return baseService.getBizProjectContractDetailsById(id);
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除项目合同明细信息",httpMethod = "DELETE",notes = "批量删除桥梁专项检查信息")
    public CommonResult<String> removes(@ApiParam(name = "ids",value = "对各主键用逗号分隔",required = true) @RequestParam String... ids) throws Exception{
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true,"删除成功");
    }

    @RequestMapping(value = "/updateContractDetails",method = RequestMethod.DELETE,produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除项目合同明细信息",httpMethod = "DELETE",notes = "逻辑删除桥梁专项检查信息")
    public CommonResult<String> updateContractDetails(@ApiParam(name = "ids",value = "ID集合以，隔开",required = true)
                                              @RequestParam(value = "ids",required = true)String ids)throws Exception{
        if (StringUtils.isNotBlank(ids)){
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<BizProjectContractDetails> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_",idsList);
            updateWrapper.set("is_dele_","1");
            baseService.update(null,updateWrapper);
        }
        return new CommonResult<>(true,"删除成功");
    }
}
