package com.artfess.yhxt.check.regular.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.yhxt.check.regular.manager.CheckExportManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhx
 * @create 2022/2/23
 */
@RestController
@RequestMapping("/checkExport/v1/")
@Api(tags = "定期、经常检查导出")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class CheckExportController {
    @Resource
    private CheckExportManager checkExportManager;

    @RequestMapping(value = "bridge/exportBridgeOftenList", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导出桥梁经常检查列表", httpMethod = "GET", notes = "导出桥梁经常检查列表")
    public void exportBridgeOftenList(@ApiParam(name = "ids", value = "桥梁id用逗号分割", required = false) @RequestParam String ids, HttpServletResponse response) throws Exception {
        HSSFWorkbook exportFile = checkExportManager.exportBridgeOftenList(ids, response);
        downloadExcel(exportFile,"桥梁经常检查",response);
    }

    @RequestMapping(value = "tunnel/exportTunnelOftenList", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导出隧道经常检查列表", httpMethod = "GET", notes = "导出隧道经常检查列表")
    public void exportTunnelOftenList(@ApiParam(name = "ids", value = "隧道id用逗号分割", required = false) @RequestParam String ids, HttpServletResponse response) throws Exception {
        HSSFWorkbook exportFile = checkExportManager.exportTunnelOftenList(ids, response);
        downloadExcel(exportFile,"隧道经常检查",response);
    }

    @RequestMapping(value = "culvert/exportCulvertOftenList", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导出涵洞经常检查列表", httpMethod = "GET", notes = "导出涵洞经常检查列表")
    public void exportCulvertOftenList(@ApiParam(name = "ids", value = "涵洞id用逗号分割", required = false) @RequestParam String ids, HttpServletResponse response) throws Exception {
        HSSFWorkbook exportFile = checkExportManager.exportCulvertOftenList(ids, response);
        downloadExcel(exportFile,"涵洞经常检查",response);
    }

    @RequestMapping(value = "sideSlope/exportSideSlopeOftenList", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导出边坡经常检查列表", httpMethod = "GET", notes = "导出边坡经常检查列表")
    public void exportSideSlopeOftenList(@ApiParam(name = "ids", value = "边坡id用逗号分割", required = false) @RequestParam String ids, HttpServletResponse response) throws Exception {
        HSSFWorkbook exportFile = checkExportManager.exportSideSlopeOftenList(ids, response);
        downloadExcel(exportFile,"边坡经常检查",response);
    }

    @RequestMapping(value = "bridge/exportBridgeRegularList", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导出桥梁定期检查列表", httpMethod = "GET", notes = "导出桥梁定期检查列表")
    public void exportBridgeRegularList(@ApiParam(name = "ids", value = "桥梁id用逗号分割", required = false) @RequestParam String ids, HttpServletResponse response) throws Exception {
        HSSFWorkbook exportFile = checkExportManager.exportBridgeRegularList(ids, response);
        downloadExcel(exportFile,"桥梁定期检查",response);
    }

    @RequestMapping(value = "tunnel/exportTunnelRegularList", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导出隧道定期检查列表", httpMethod = "GET", notes = "导出隧道定期检查列表")
    public void exportTunnelRegularList(@ApiParam(name = "ids", value = "隧道id用逗号分割", required = false) @RequestParam String ids, HttpServletResponse response) throws Exception {
        HSSFWorkbook exportFile = checkExportManager.exportTunnelRegularList(ids, response);
        downloadExcel(exportFile,"隧道定期检查",response);
    }

    @RequestMapping(value = "culvert/exportCulvertRegularList", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导出涵洞定期检查列表", httpMethod = "GET", notes = "导出涵洞定期检查列表")
    public void exportCulvertRegularList(@ApiParam(name = "ids", value = "涵洞id用逗号分割", required = false) @RequestParam String ids, HttpServletResponse response) throws Exception {
        HSSFWorkbook exportFile = checkExportManager.exportCulvertRegularList(ids, response);
        downloadExcel(exportFile,"涵洞定期检查",response);
    }

    @RequestMapping(value = "sideSlope/exportSideSlopeRegularList", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "导出边坡定期检查列表", httpMethod = "GET", notes = "导出边坡定期检查列表")
    public void exportSideSlopeRegularList(@ApiParam(name = "ids", value = "隧道id用逗号分割", required = false) @RequestParam String ids, HttpServletResponse response) throws Exception {
        HSSFWorkbook exportFile = checkExportManager.exportSideSlopeRegularList(ids, response);
        downloadExcel(exportFile,"边坡定期检查",response);
    }






    //下载文件
    private static void downloadExcel(HSSFWorkbook workBook, String fileName, HttpServletResponse response) throws IOException {
        String filedisplay = URLEncoder.encode(fileName+ ".xls", "utf-8");
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
        response.addHeader("filename", filedisplay);
        OutputStream os = null;
        try {
            os = response.getOutputStream();
            workBook.write(os);
            os.flush();
            os.close();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (os != null) {
                os.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        HSSFWorkbook workbook=new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("桥梁经常检查");
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 5));
        HSSFRow row = sheet.createRow(0);
        row.createCell(0).setCellValue("公路管理机构名称:"+"bridge.getCompanyName()");
        HSSFRow row1 = sheet.createRow(1);
        row1.createCell(0).setCellValue("路线编号");
        row1.createCell(1).setCellValue("road.getCode()");
        row1.createCell(2).setCellValue("路线名称");
        row1.createCell(3).setCellValue("road.getName()");
        row1.createCell(4).setCellValue("桥位桩号");
        row1.createCell(5).setCellValue("bridge.getCentPegK()");
        HSSFRow row2 = sheet.createRow(2);
        row2.createCell(0).setCellValue("桥梁编号");
        row2.createCell(1).setCellValue("bridge.getNumber()");
        row2.createCell(2).setCellValue("桥梁名称");
        row2.createCell(3).setCellValue("bridge.getName()");
        row2.createCell(4).setCellValue("养护单位");
        row2.createCell(5).setCellValue("bridge.getOfficeName()");
        HSSFRow row3 = sheet.createRow(3);
        row3.createCell(0).setCellValue("检查项目");
        row3.createCell(1).setCellValue("缺损类型");
        row3.createCell(3).setCellValue("缺损范围");
        row3.createCell(4).setCellValue("处治建议");
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 4, 5));

        try {
            FileOutputStream fileOutputStream = new FileOutputStream("E:/test2.xls");
            workbook.write(fileOutputStream);
        } catch (Exception e) {
            e.printStackTrace();
        }finally {
            workbook.close();
        }
    }
}
