package com.artfess.yhxt.budget.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 
 *
 * @company 阿特菲斯信息技术有限公司
 * @author naf
 * @since 2023-05-30
 */
@ApiModel(value="YearBudgetDetailedLog", description="已用预算明细改变日志表")
@Data
@TableName("BIZ_YEAR_BUDGET")
public class YearBudgetDetailedLog extends BaseModel<YearBudgetDetailedLog> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "Id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "年度总预算id")
    @TableField("YEAR_BUDGET_ID_")
    private String yearBudgetId;

    @ApiModelProperty(value = "年度总预算明细id")
    @TableField("YEAR_BUDGET_DETAIL_ID_")
    private String yearBudgetDetailId;

    @ApiModelProperty(value = "工单id")
    @TableField("WORK_ORDER_INFORMATION_ID_")
    private String workOrderInformationId;

    @ApiModelProperty(value = "所属年限")
    @TableField("ASCRIPTION_YEAR_")
    private Integer ascriptionYear;

    @ApiModelProperty(value = "改变金额")
    @TableField("TAX_MONEY_")
    private BigDecimal taxMoney;

    @ApiModelProperty(value = "增加 1 减少 0")
    @TableField("TYPE_")
    private Integer type;

    @ApiModelProperty(value = "备注")
    @TableField("REMARK_")
    private String remark;

    @ApiModelProperty(value = "改变时间")
    @TableField("LOG_TIME_")
    private LocalDateTime logTime;

}
