package com.artfess.yhxt.basedata.vo;

import com.artfess.yhxt.basedata.model.BizCulvertInformation;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author zhx
 * @create 2021/8/9
 */
@Data
public class CulvertCheckVo extends BizCulvertInformation {
    @ApiModelProperty(value = "检查日期")
    @TableField("CHECK_DATE_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private Date checkDate;


    @ApiModelProperty(value = "下次检查日期")
    @TableField("CHECK_NEW_DAY_")
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    private Date checkNewDay;



    @ApiModelProperty(value = "总体评价")
    @TableField("EVALUATE_")
    private String evaluate;



    @ApiModelProperty(value = "总体评价值")
    @TableField("EVALUATE_VALUE_")
    private String evaluateValue;

    @ApiModelProperty(value = "涵洞经常预警时间")
    @TableField(exist = false)
    private String value;

    @ApiModelProperty(value = "距检查天数")
    @TableField(exist = false)
    private Integer checkDays;

    @ApiModelProperty(value = "距上次检查天数")
    @TableField(exist = false)
    private Integer alreadyCheckDays;

    @ApiModelProperty(value = "是否临期 0:未临期 1:临期")
    @TableField(exist = false)
    private Integer temporary;


}
