package com.artfess.yhxt.basedata.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.manager.OrgManager;
import com.artfess.yhxt.basedata.vo.HumanCountVo;

import com.artfess.yhxt.basedata.vo.MigrantBuildersInformationVo;
import com.artfess.yhxt.basedata.vo.VehicleCountVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.hasor.utils.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.yhxt.basedata.model.MigrantBuildersInformation;
import com.artfess.yhxt.basedata.manager.MigrantBuildersInformationManager;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工人员管理表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author xzh
 * @since 2021-10-12
 */
@RestController
@RequestMapping("/bizMigrantBuildersInformation/v1/")
@Api(tags = "施工人员")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class MigrantBuildersInformationController extends BaseController<MigrantBuildersInformationManager, MigrantBuildersInformation> {
    @Resource
    private OrgManager orgManager;


    @RequestMapping(value = "getCountVo", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "获取施工人员统计", httpMethod = "POST", notes = "获取车辆统计")
    public List<HumanCountVo> getVehicleCountVo() throws Exception {
        return baseService.getCountVo();
    }


    @RequestMapping(value = "/saveMigrantWorkersInformation",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改施工人员",httpMethod = "POST")
    public CommonResult<String> saveMigrantWorkersInformation(@ApiParam(name = "migrantBuildersInformation",value = "施工人员对象") @RequestBody MigrantBuildersInformation migrantBuildersInformation) throws Exception {
        String msg = "添加成功";
        if (StringUtils.isEmpty(migrantBuildersInformation.getId())){
            migrantBuildersInformation.setIsDele("0");
            baseService.create(migrantBuildersInformation);
        }else {
            baseService.update(migrantBuildersInformation);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }

    @RequestMapping(value = "/save",method = RequestMethod.POST,produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "保存,修改施工人员及附件",httpMethod = "POST")
    public CommonResult<String> save(@ApiParam(name = "migrantBuildersInformationVo",value = "施工人员、附件 Vo对象") @RequestBody MigrantBuildersInformationVo migrantBuildersInformationVo) throws Exception {
        String msg = "添加成功";
        MigrantBuildersInformation migrantBuildersInformation = migrantBuildersInformationVo.getMigrantBuildersInformation();
        if (StringUtils.isEmpty(migrantBuildersInformation.getId())){
            migrantBuildersInformation.setIsDele("0");
            baseService.saveVo(migrantBuildersInformationVo);
        }else {
            baseService.updateVo(migrantBuildersInformationVo);
            msg = "修改成功";
        }
        return new CommonResult<String>(msg);
    }


    @RequestMapping(value = "getJson",method = RequestMethod.POST,produces = {"application/json;charset=utf-8" })
    @ApiOperation(value = "分页查询施工人员",httpMethod ="POST")
    public PageList<MigrantBuildersInformation> getJson(@ApiParam(name = "queryFilter",value = "分页查询信息")@RequestBody QueryFilter<MigrantBuildersInformation> queryFilter){
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        List<QueryField> querys = queryFilter.getQuerys();

        if (null != querys){
            List<String > strings = querys.stream().filter(e -> e.getProperty().equals("companyId")).map(e -> e.getValue().toString()).collect(Collectors.toList());
            for (QueryField query : querys) {
                if(query.getProperty().equals("companyId")){
                    String s = query.getValue().toString();
                    if(!StringUtil.isEmpty(s)){
                        String companyId = strings.get(0);
                        HashMap<String, String> map = new HashMap<>();
                        map.put("id",companyId);
                        Map<String, Set<String>> childrenIds = orgManager.getChildrenIds(map);
                        Set<String> ids = childrenIds.get("id");
                        String idstr = ids.stream().map(String::valueOf).collect(Collectors.joining(","));

                        query.setValue(idstr);
                    }
                }
            }
        }
        PageList<MigrantBuildersInformation> pageList = baseService.queryMigrantBuildersInformation(queryFilter);
        return pageList;
    }

    @GetMapping(value = "get/{id}")
    @ApiOperation(value = "根据ID查询施工人员",httpMethod = "GET",notes = "根据ID查询施工人员")
    public MigrantBuildersInformation get(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        MigrantBuildersInformation migrantBuildersInformation = baseService.getMigrantBuildersById(id);
        return migrantBuildersInformation;
    }


    @GetMapping(value = "getVo/{id}")
    @ApiOperation(value = "根据ID查询施工人员、附件",httpMethod = "GET",notes = "根据ID查询施工人员")
    public MigrantBuildersInformationVo getByVo(@ApiParam(name = "id",value = "业务对象主键",required = true)@PathVariable String id) throws Exception{
        MigrantBuildersInformationVo migrantBuildersInformationVo = baseService.getByIdVo(id);
        return migrantBuildersInformationVo;
    }

    @DeleteMapping(value = "/removes")
    @ApiOperation(value = "批量删除施工人员",httpMethod = "DELETE",notes = "批量删除施工人员")
    public CommonResult<String> removes(@ApiParam(name = "ids",value = "对各主键用逗号分隔",required = true) @RequestParam String... ids) throws Exception{
        baseService.removeByIds(Arrays.asList(ids));
        return new CommonResult<String>(true,"删除成功");
    }

    @RequestMapping(value = "/updateMigrantWorkersInformation",method = RequestMethod.DELETE,produces = {"application/json;charset=utf-8"})
    @ApiOperation(value = "逻辑删除施工人员",httpMethod = "DELETE",notes = "逻辑删除施工人员")
    public CommonResult<String> updateMigrantWorkersInformation(@ApiParam(name = "ids",value = "ID集合以，隔开",required = true)
                                                                @RequestParam(value = "ids",required = true)String ids)throws Exception{
        if (StringUtils.isNotBlank(ids)){
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper<MigrantBuildersInformation> updateWrapper = new UpdateWrapper<>();
            updateWrapper.in("id_",idsList);
            updateWrapper.set("is_dele_","1");
            baseService.update(null,updateWrapper);
        }
        return new CommonResult<>(true,"删除成功");
    }
}
