/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.check.regular.manager.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.TunnelInformationManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.TunnelInformation;
import com.artfess.yhxt.check.detail.dao.TunnelOftenCheckDetailDao;
import com.artfess.yhxt.check.detail.manager.TunnelOftenCheckDetailManager;
import com.artfess.yhxt.check.detail.model.TunnelOftenCheckDetail;
import com.artfess.yhxt.check.regular.dao.TunnelOftenCheckDao;
import com.artfess.yhxt.check.regular.manager.TunnelOftenCheckManager;
import com.artfess.yhxt.check.regular.model.TunnelOftenCheck;
import com.artfess.yhxt.check.regular.vo.TunnelOftenCheckVo;
import com.artfess.yhxt.statistics.dao.SiteStatisticDao;
import com.artfess.yhxt.statistics.model.SiteStatistic;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TunnelOftenCheckManagerImpl
extends BaseManagerImpl<TunnelOftenCheckDao, TunnelOftenCheck>
implements TunnelOftenCheckManager {
    @Autowired
    private TunnelOftenCheckDetailManager tunnelOftenCheckDetailManager;
    @Resource
    private TunnelOftenCheckDetailDao tunnelOftenCheckDetailDao;
    @Resource
    private TunnelInformationManager tunnelInformationManager;
    @Resource
    private SiteStatisticDao siteStatisticDao;
    @Resource
    private AccessoryManager accessoryManager;

    @Override
    public PageList<TunnelOftenCheck> queryTunnelOftenCheck(QueryFilter<TunnelOftenCheck> queryFilter) {
        List sorter;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (null == (sorter = queryFilter.getSorter()) || sorter.isEmpty()) {
            sorter.add(new FieldSort("CHECK_DATE_", Direction.DESC));
            queryFilter.setSorter(sorter);
        }
        IPage<TunnelOftenCheck> result = ((TunnelOftenCheckDao)this.baseMapper).queryTunnelOftenCheck((IPage<TunnelOftenCheck>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<TunnelOftenCheck>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void saveTunnelOftenCheck(TunnelOftenCheckVo vo) {
        TunnelOftenCheck tunnelOftenCheck = vo.getTunnelOftenCheck();
        tunnelOftenCheck.setIsDele("0");
        this.saveOrUpdate((Object)tunnelOftenCheck);
        vo.getTunnelOftenCheckDetails().forEach(s -> {
            s.setId(null);
            s.setTunnelOftenCheckId(tunnelOftenCheck.getId());
            this.tunnelOftenCheckDetailManager.saveOrUpdate(s);
        });
        List<Accessory> accessoryList = vo.getAccessories();
        String id = tunnelOftenCheck.getId();
        if (null != accessoryList && accessoryList.size() > 0) {
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }
    }

    @Override
    public void updateTunnelOftenCheck(TunnelOftenCheckVo vo) {
        TunnelOftenCheck tunnelOftenCheck = vo.getTunnelOftenCheck();
        this.update((Model)tunnelOftenCheck);
        vo.getTunnelOftenCheckDetails().forEach(s -> {
            s.setTunnelOftenCheckId(tunnelOftenCheck.getId());
            this.tunnelOftenCheckDetailManager.saveOrUpdate(s);
        });
        List<Accessory> accessoryList = vo.getAccessories();
        String id = tunnelOftenCheck.getId();
        if (null != accessoryList && accessoryList.size() > 0) {
            this.accessoryManager.delAccessoryBySourceId(id);
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }

    @Override
    public TunnelOftenCheckVo getTunnelOftenCheckById(String id) {
        TunnelOftenCheckVo checkVo = new TunnelOftenCheckVo();
        TunnelOftenCheck tunnelOftenCheck = (TunnelOftenCheck)((Object)this.getById((Serializable)((Object)id)));
        if (tunnelOftenCheck != null) {
            checkVo.setTunnelOftenCheck(tunnelOftenCheck);
            QueryWrapper queryWrapper = new QueryWrapper();
            if (StringUtils.isNotBlank((CharSequence)tunnelOftenCheck.getId())) {
                queryWrapper.eq((Object)"TUNNEL_OFTEN_CHECK_ID_", (Object)tunnelOftenCheck.getId());
                List bridgeOftenCheckDetails = this.tunnelOftenCheckDetailDao.selectList((Wrapper)queryWrapper);
                checkVo.setTunnelOftenCheckDetails(bridgeOftenCheckDetails);
            }
            List<Accessory> accessories = this.accessoryManager.getAccessoryBySourceId(id);
            checkVo.setAccessories(accessories);
        }
        return checkVo;
    }

    @Override
    public void importExcelData(MultipartFile file, TunnelOftenCheck parseObject) {
        Assert.notNull((Object)((Object)parseObject), (String)"\u4e3b\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, TunnelOftenCheckDetail.class, (ImportParams)new ImportParams());
            TunnelOftenCheckVo vo = new TunnelOftenCheckVo();
            vo.setTunnelOftenCheck(parseObject);
            vo.setTunnelOftenCheckDetails(data);
            this.saveTunnelOftenCheck(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveSiteStatistic(TunnelOftenCheck tunnelOftenCheck) {
        SiteStatistic siteStatistic = new SiteStatistic();
        String tunnelId = tunnelOftenCheck.getTunnelId();
        TunnelInformation tunnel = (TunnelInformation)((Object)this.tunnelInformationManager.getById((Serializable)((Object)tunnelId)));
        siteStatistic.setRoadSegmentId(tunnel.getRoadSegmentId());
        siteStatistic.setRoadSegmentName(tunnel.getRoadSegmentName());
        siteStatistic.setCompanyId(tunnelOftenCheck.getCompanyId());
        siteStatistic.setCompanyName(tunnelOftenCheck.getCompanyName());
        siteStatistic.setSiteCode(4);
        siteStatistic.setSiteName("\u96a7\u9053\u7ecf\u5e38\u68c0\u67e5");
        Date checkDate = tunnelOftenCheck.getCheckDate();
        String month = new SimpleDateFormat("yyyy-MM").format(checkDate);
        siteStatistic.setAccDateMonth(month);
        String year = new SimpleDateFormat("yyyy").format(checkDate);
        siteStatistic.setAccDateYear(year);
        siteStatistic.setComplete("1");
        siteStatistic.setCompleteNo("0");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)month), (Object)"ACC_DATE_MONTH_", (Object)month);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)year), (Object)"ACC_DATE_YEAR_", (Object)year);
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)tunnel.getRoadSegmentId()), (Object)"ROAD_SEGMENT_ID_", (Object)tunnel.getRoadSegmentId());
        queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)tunnel.getCompanyId()), (Object)"COMPANY_ID_", (Object)tunnel.getCompanyId());
        queryWrapper.eq((Object)"SITE_CODE_", (Object)4);
        queryWrapper.eq((Object)"SITE_NAME_", (Object)"\u96a7\u9053\u7ecf\u5e38\u68c0\u67e5");
        List siteStatistics = this.siteStatisticDao.selectList((Wrapper)queryWrapper);
        if (siteStatistics.size() > 0) {
            SiteStatistic statistic = (SiteStatistic)((Object)siteStatistics.get(0));
            statistic.setComplete(String.valueOf(Integer.parseInt(statistic.getCompleteNo()) + 1));
            this.siteStatisticDao.update((Object)siteStatistic, (Wrapper)queryWrapper);
        } else {
            this.siteStatisticDao.insert((Object)siteStatistic);
        }
    }
}

