/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialcheck.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.specialcheck.dao.BizBridgeSpecialCheckDao;
import com.artfess.yhxt.specialcheck.manager.BizBridgeSpecialCheckManager;
import com.artfess.yhxt.specialcheck.model.BizBridgeSpecialCheck;
import com.artfess.yhxt.specialcheck.vo.BizBridgeSpecialCheckVo;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class BizBridgeSpecialCheckManagerImpl
extends BaseManagerImpl<BizBridgeSpecialCheckDao, BizBridgeSpecialCheck>
implements BizBridgeSpecialCheckManager {
    @Resource
    PermissionUtils permissionUtils;
    @Resource
    private AccessoryManager accessoryManager;
    @Resource
    BaseContext baseContext;

    @Override
    public PageList<BizBridgeSpecialCheck> queryBizBridgeSpecialCheck(QueryFilter<BizBridgeSpecialCheck> queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        IPage<BizBridgeSpecialCheck> result = ((BizBridgeSpecialCheckDao)this.baseMapper).queryBizBridgeSpecialCheck((IPage<BizBridgeSpecialCheck>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<BizBridgeSpecialCheck>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public BizBridgeSpecialCheck getBizBridgeSpecialById(String id) {
        BizBridgeSpecialCheck bizBridgeSpecialCheck = (BizBridgeSpecialCheck)((Object)((BizBridgeSpecialCheckDao)this.baseMapper).selectById((Serializable)((Object)id)));
        return bizBridgeSpecialCheck;
    }

    @Override
    public void saveVo(BizBridgeSpecialCheckVo bizBridgeSpecialCheckVo) {
        BizBridgeSpecialCheck bizBridgeSpecialCheck = bizBridgeSpecialCheckVo.getBizBridgeSpecialCheck();
        this.create((Model)bizBridgeSpecialCheck);
        List<Accessory> accessoryList = bizBridgeSpecialCheckVo.getAccessories();
        String id = bizBridgeSpecialCheck.getId();
        if (accessoryList.size() > 0) {
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveBatch(accessoryList);
        }
    }

    @Override
    public void updateVo(BizBridgeSpecialCheckVo bizBridgeSpecialCheckVo) {
        BizBridgeSpecialCheck bizBridgeSpecialCheck = bizBridgeSpecialCheckVo.getBizBridgeSpecialCheck();
        List<Accessory> accessoryList = bizBridgeSpecialCheckVo.getAccessories();
        this.update((Model)bizBridgeSpecialCheck);
        String id = bizBridgeSpecialCheck.getId();
        if (accessoryList.size() > 0) {
            this.accessoryManager.delAccessoryBySourceId(id);
            accessoryList.forEach(s -> s.setSourceId(id));
            this.accessoryManager.saveOrUpdateBatch(accessoryList);
        }
    }

    @Override
    public BizBridgeSpecialCheckVo getVo(String id) {
        BizBridgeSpecialCheckVo bizBridgeSpecialCheckVo = new BizBridgeSpecialCheckVo();
        BizBridgeSpecialCheck bizBridgeSpecialCheck = (BizBridgeSpecialCheck)((Object)((BizBridgeSpecialCheckDao)this.baseMapper).selectById((Serializable)((Object)id)));
        List<Accessory> accessoryList = this.accessoryManager.getAccessoryBySourceId(id);
        bizBridgeSpecialCheckVo.setBizBridgeSpecialCheck(bizBridgeSpecialCheck);
        bizBridgeSpecialCheckVo.setAccessories(accessoryList);
        return bizBridgeSpecialCheckVo;
    }
}

