/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.dao.BizRoadsideFacilitiesDao;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.BizRoadsideFacilitiesManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.BizRoadsideFacilities;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.statistics.vo.Org4roadSideVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BizRoadsideFacilitiesManagerImpl
extends BaseManagerImpl<BizRoadsideFacilitiesDao, BizRoadsideFacilities>
implements BizRoadsideFacilitiesManager {
    @Resource
    BizRoadsideFacilitiesDao bizRoadsideFacilitiesDao;
    @Resource
    AccessoryManager accessoryManager;
    @Resource
    BaseContext baseContext;
    @Resource
    PermissionUtils permissionUtils;
    @Resource
    private OrgDao orgDao;
    @Resource
    private RoadManager roadManager;

    @Override
    public List<Org4roadSideVO> getRoadSideCount() {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        List<Org4roadSideVO> lists = new ArrayList<Org4roadSideVO>();
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        List<Org> list = BizRoadsideFacilitiesManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            Org4roadSideVO fvo = new Org4roadSideVO();
            BeanUtils.copyProperties((Object)org, (Object)fvo);
            lists.add(fvo);
        }
        lists = BizRoadsideFacilitiesManagerImpl.getChild(lists, orgId);
        return this.setCount(lists);
    }

    public List<Org4roadSideVO> setCount(List<Org4roadSideVO> list) {
        Iterator<Org4roadSideVO> it = list.iterator();
        while (it.hasNext()) {
            Org4roadSideVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newCount(roadList, orgVO);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setCount(orgVO.getChirldren());
        }
        return list;
    }

    public Org4roadSideVO newCount(List<String> ids, Org4roadSideVO orgVO) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        wrapper.eq((Object)"IS_DELE_", (Object)0);
        List sides = this.list((Wrapper)wrapper);
        List pivot = sides.stream().filter(bizRoadsideFacilities -> Objects.equals(bizRoadsideFacilities.getType(), "1")).collect(Collectors.toList());
        List ringRoad = sides.stream().filter(bizRoadsideFacilities -> Objects.equals(bizRoadsideFacilities.getType(), "2")).collect(Collectors.toList());
        List tollGate = sides.stream().filter(bizRoadsideFacilities -> Objects.equals(bizRoadsideFacilities.getType(), "3")).collect(Collectors.toList());
        List service = sides.stream().filter(bizRoadsideFacilities -> Objects.equals(bizRoadsideFacilities.getType(), "4")).collect(Collectors.toList());
        orgVO.setPivotCount(pivot.size());
        orgVO.setTollGateCount(tollGate.size());
        orgVO.setServiceCount(service.size());
        orgVO.setRingRoadCount(ringRoad.size());
        if ("4".equals(orgVO.getGrade())) {
            orgVO.setRoadSegmentId(ids.get(0));
        }
        return orgVO;
    }

    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            BizRoadsideFacilitiesManagerImpl.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    public static List<Org4roadSideVO> getChild(List<Org4roadSideVO> allList, String pCode) {
        ArrayList<Org4roadSideVO> returnList = new ArrayList<Org4roadSideVO>();
        for (Org4roadSideVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(BizRoadsideFacilitiesManagerImpl.getChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    @Override
    public PageList<BizRoadsideFacilities> queryBizRoadsideFacilities(QueryFilter<BizRoadsideFacilities> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        IPage<BizRoadsideFacilities> result = ((BizRoadsideFacilitiesDao)this.baseMapper).getBizRoadsideFacilities((IPage<BizRoadsideFacilities>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<BizRoadsideFacilities>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public void updateBizRoadsideFacilities(String id) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq(StringUtils.isNotBlank((CharSequence)id), (Object)"id_", (Object)id);
        updateWrapper.set((Object)"is_dele_", (Object)"1");
        this.bizRoadsideFacilitiesDao.update(null, (Wrapper)updateWrapper);
    }

    @Override
    public void saveRoadside(BizRoadsideFacilities bizRoadsideFacilities) {
        List<Accessory> accessoriesTwoDimensionalView;
        List<Accessory> accessoriesLateralView;
        this.save((Object)bizRoadsideFacilities);
        List<Accessory> accessoriesFrontView = bizRoadsideFacilities.getAccessoriesFrontView();
        if (null != accessoriesFrontView && accessoriesFrontView.size() > 0) {
            accessoriesFrontView.forEach(s -> {
                s.setSourceId(bizRoadsideFacilities.getId());
                s.setGroup("frontView");
            });
            this.accessoryManager.saveBatch(accessoriesFrontView);
        }
        if (null != (accessoriesLateralView = bizRoadsideFacilities.getAccessoriesLateralView()) && accessoriesLateralView.size() > 0) {
            accessoriesLateralView.forEach(s -> {
                s.setSourceId(bizRoadsideFacilities.getId());
                s.setGroup("lateralView");
            });
            this.accessoryManager.saveBatch(accessoriesLateralView);
        }
        if (null != (accessoriesTwoDimensionalView = bizRoadsideFacilities.getAccessoriesTwoDimensionalView()) && accessoriesTwoDimensionalView.size() > 0) {
            accessoriesTwoDimensionalView.forEach(s -> {
                s.setSourceId(bizRoadsideFacilities.getId());
                s.setGroup("twoDimensionalPlan");
            });
            this.accessoryManager.saveBatch(accessoriesTwoDimensionalView);
        }
    }

    @Override
    public void updateRoadside(BizRoadsideFacilities bizRoadsideFacilities) {
        List<Accessory> accessoriesTwoDimensionalView;
        List<Accessory> accessoriesLateralView;
        this.update((Model)bizRoadsideFacilities);
        this.accessoryManager.delAccessoryBySourceId(bizRoadsideFacilities.getId());
        List<Accessory> accessoriesFrontView = bizRoadsideFacilities.getAccessoriesFrontView();
        if (null != accessoriesFrontView && accessoriesFrontView.size() > 0) {
            accessoriesFrontView.forEach(s -> {
                s.setSourceId(bizRoadsideFacilities.getId());
                s.setGroup("frontView");
            });
            this.accessoryManager.saveBatch(accessoriesFrontView);
        }
        if (null != (accessoriesLateralView = bizRoadsideFacilities.getAccessoriesLateralView()) && accessoriesLateralView.size() > 0) {
            accessoriesLateralView.forEach(s -> {
                s.setSourceId(bizRoadsideFacilities.getId());
                s.setGroup("lateralView");
            });
            this.accessoryManager.saveBatch(accessoriesLateralView);
        }
        if (null != (accessoriesTwoDimensionalView = bizRoadsideFacilities.getAccessoriesTwoDimensionalView()) && accessoriesTwoDimensionalView.size() > 0) {
            accessoriesTwoDimensionalView.forEach(s -> {
                s.setSourceId(bizRoadsideFacilities.getId());
                s.setGroup("twoDimensionalPlan");
            });
            this.accessoryManager.saveBatch(accessoriesTwoDimensionalView);
        }
    }

    @Override
    public BizRoadsideFacilities getByFacilitiesId(String id) {
        BizRoadsideFacilities bizRoadsideFacilities = (BizRoadsideFacilities)((Object)((BizRoadsideFacilitiesDao)this.baseMapper).selectById((Serializable)((Object)id)));
        List<Accessory> accessories = this.accessoryManager.getAccessoryBySourceId(id);
        ArrayList<Accessory> accessoriesFrontView = new ArrayList<Accessory>();
        ArrayList<Accessory> accessoriesLateralView = new ArrayList<Accessory>();
        ArrayList<Accessory> accessoriesTwoDimensionalView = new ArrayList<Accessory>();
        if (accessories != null && accessories.size() > 0) {
            accessories.forEach(s -> {
                String group = s.getGroup();
                if ("frontView".equalsIgnoreCase(group)) {
                    accessoriesFrontView.add((Accessory)((Object)s));
                }
                if ("lateralView".equalsIgnoreCase(group)) {
                    accessoriesLateralView.add((Accessory)((Object)s));
                }
                if ("twoDimensionalPlan".equalsIgnoreCase(group)) {
                    accessoriesTwoDimensionalView.add((Accessory)((Object)s));
                }
            });
        }
        bizRoadsideFacilities.setAccessoriesFrontView(accessoriesFrontView);
        bizRoadsideFacilities.setAccessoriesLateralView(accessoriesLateralView);
        bizRoadsideFacilities.setAccessoriesTwoDimensionalView(accessoriesTwoDimensionalView);
        return bizRoadsideFacilities;
    }
}

