package com.artfess.ueditor.upload.impl;

import com.artfess.ueditor.define.AppInfo;
import com.artfess.ueditor.define.BaseState;
import com.artfess.ueditor.define.State;
import com.artfess.ueditor.upload.StorageService;
import org.springframework.stereotype.Component;

import java.io.InputStream;

/**
 * 默认实现，未对附件做任何处理，直接返回上传失败的结果
 *
 * @author heyifan
 * @company 广州宏天软件股份有限公司
 * @email heyf@jee-soft.cn
 * @date 2018年12月28日
 */
@Component
public class StorageServiceEmptyImpl implements StorageService {
    @Override
    public State saveBinaryFile(byte[] data, String path) {
        return getState();
    }

    @Override
    public State saveFileByInputStream(InputStream is, String path) {
        return getState();
    }

    private State getState() {
        State state = new BaseState(false, AppInfo.IO_ERROR);
        state.putInfo("code", "unimplemented");
        state.putInfo("message", "no implements for StorageService.");
        return state;
    }
}
