package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.sysConfig.persistence.dao.SysErrorLogsDao;
import com.artfess.sysConfig.persistence.manager.SysErrorLogsManager;
import com.artfess.sysConfig.persistence.model.SysErrorLogs;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 
 * <pre> 
 * 描述：系统错误日志 处理实现类
 * 构建组：artfess
 * 作者:baseli
 * 日期:2021年6月17日09:53:20
 * </pre>
 */
@Service("sysErrorLogsManager")
public class SysErrorLogsManagerImpl extends BaseManagerImpl<SysErrorLogsDao, SysErrorLogs> implements SysErrorLogsManager{
	
	@Override
	public void removeByEexcutionTime(List<Map<String, Object>> params) {
		baseMapper.removeByEexcutionTime(params);
	}
	
	@Override
	public void create(SysErrorLogs log) {
		if(StringUtil.isNotEmpty(log.getOpeName()) && log.getOpeName().length()>480){
			log.setOpeName(log.getOpeName().substring(0, 480));
		}
		this.save(log);
	}
}
