/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.util;

import com.artfess.base.exception.BaseException;
import com.artfess.file.util.ConverterUtils;
import java.io.File;
import javax.annotation.Resource;
import org.apache.commons.io.FilenameUtils;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.springframework.stereotype.Component;

@Component
public class OfficeToPdf {
    @Resource
    ConverterUtils converterUtils;

    public boolean openOfficeToPDF(String inputFilePath, String outputFilePath) {
        return this.office2pdf(inputFilePath, outputFilePath);
    }

    public static void converterFile(File inputFile, String outputFilePath_end, String inputFilePath, String outputFilePath, OfficeDocumentConverter converter) {
        File outputFile = new File(outputFilePath_end);
        if (!outputFile.exists()) {
            outputFile.getParentFile().mkdirs();
        }
        String outputExtension = FilenameUtils.getExtension((String)outputFile.getName());
        try {
            converter.convert(inputFile, outputFile);
        }
        catch (NullPointerException e) {
            throw new BaseException("\u672a\u627e\u5230\u670d\u52a1\u7aef\u7684\u9644\u4ef6\u9884\u89c8\u7ec4\u4ef6.", (Throwable)e);
        }
    }

    public boolean office2pdf(String inputFilePath, String outputFilePath) {
        boolean flag = false;
        OfficeDocumentConverter converter = this.converterUtils.getDocumentConverter();
        if (null != inputFilePath) {
            File inputFile = new File(inputFilePath);
            if (null == outputFilePath) {
                String outputFilePath_end = OfficeToPdf.getOutputFilePath(inputFilePath);
                if (inputFile.exists()) {
                    OfficeToPdf.converterFile(inputFile, outputFilePath_end, inputFilePath, outputFilePath, converter);
                    flag = true;
                }
            } else if (inputFile.exists()) {
                OfficeToPdf.converterFile(inputFile, outputFilePath, inputFilePath, outputFilePath, converter);
                flag = true;
            }
        } else {
            flag = false;
        }
        return flag;
    }

    public static String getOutputFilePath(String inputFilePath) {
        String outputFilePath = inputFilePath.replaceAll("." + OfficeToPdf.getPostfix(inputFilePath), ".pdf");
        return outputFilePath;
    }

    public static String getPostfix(String inputFilePath) {
        return inputFilePath.substring(inputFilePath.lastIndexOf(".") + 1);
    }
}

