/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.basedata.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.yhxt.basedata.dao.TunnelInformationDao;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.basedata.manager.RoadManager;
import com.artfess.yhxt.basedata.manager.TunnelInformationManager;
import com.artfess.yhxt.basedata.model.Accessory;
import com.artfess.yhxt.basedata.model.Road;
import com.artfess.yhxt.basedata.model.TunnelInformation;
import com.artfess.yhxt.basedata.vo.TunnelCheckVo;
import com.artfess.yhxt.basedata.vo.TunnelRegularVo;
import com.artfess.yhxt.check.regular.dao.TunnelOftenCheckDao;
import com.artfess.yhxt.check.regular.dao.TunnelRegularCheckDao;
import com.artfess.yhxt.check.regular.model.TunnelOftenCheck;
import com.artfess.yhxt.check.regular.model.TunnelRegularCheck;
import com.artfess.yhxt.statistics.dao.WorkbenchDao;
import com.artfess.yhxt.statistics.vo.Org4tunnelVO;
import com.artfess.yhxt.util.PermissionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class TunnelInformationManagerImpl
extends BaseManagerImpl<TunnelInformationDao, TunnelInformation>
implements TunnelInformationManager {
    @Resource
    private TunnelOftenCheckDao tunnelOftenCheckDao;
    @Resource
    private TunnelRegularCheckDao tunnelRegularCheckDao;
    @Resource
    private BaseContext baseContext;
    @Resource
    private AccessoryManager accessoryManager;
    @Resource
    PermissionUtils permissionUtils;
    @Resource
    private OrgDao orgDao;
    @Resource
    private OrgManager orgManager;
    @Resource
    private WorkbenchDao workbenchDao;
    @Resource
    private RoadManager roadManager;

    @Override
    public List<Org4tunnelVO> getTunnelCount() {
        String orgId = StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId()) && !"0".equals(this.baseContext.getCurrentOrgId()) ? this.baseContext.getCurrentOrgId() : "1419863231459102720";
        List<Org4tunnelVO> lists = new ArrayList<Org4tunnelVO>();
        ArrayList<Org> rtnList = new ArrayList<Org>();
        QueryWrapper rgQueryWrapper = new QueryWrapper();
        rgQueryWrapper.eq((Object)"is_dele_", (Object)"0");
        List allList = this.orgDao.selectList((Wrapper)rgQueryWrapper);
        List<Org> list = TunnelInformationManagerImpl.getOrgChild(allList, orgId, rtnList);
        for (Org org : list) {
            Org4tunnelVO fvo = new Org4tunnelVO();
            BeanUtils.copyProperties((Object)org, (Object)fvo);
            lists.add(fvo);
        }
        lists = TunnelInformationManagerImpl.getChild(lists, orgId);
        return this.setCount(lists);
    }

    public List<Org4tunnelVO> setCount(List<Org4tunnelVO> list) {
        Iterator<Org4tunnelVO> it = list.iterator();
        while (it.hasNext()) {
            Org4tunnelVO orgVO = it.next();
            Integer grade = Integer.valueOf(orgVO.getGrade());
            List<String> roadList = new ArrayList<String>();
            if (grade < 4) {
                QueryWrapper roadQueryWrapper = new QueryWrapper();
                roadQueryWrapper.like((Object)"COMPANY_IDS_", (Object)orgVO.getId());
                roadList = this.roadManager.list((Wrapper)roadQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            } else if (grade == 4) {
                QueryWrapper roadByNameQueryWrapper = new QueryWrapper();
                roadByNameQueryWrapper.eq((Object)"NAME_", (Object)orgVO.getName());
                roadList = this.roadManager.list((Wrapper)roadByNameQueryWrapper).stream().map(Road::getId).collect(Collectors.toList());
            }
            if (roadList.size() > 0) {
                orgVO = this.newCount(roadList, orgVO);
            } else {
                it.remove();
            }
            if (orgVO.getChirldren().size() <= 0 || Integer.valueOf(orgVO.getGrade()) >= 4) continue;
            this.setCount(orgVO.getChirldren());
        }
        return list;
    }

    public Org4tunnelVO newCount(List<String> ids, Org4tunnelVO orgVO) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"ROAD_SEGMENT_ID_", ids);
        wrapper.eq((Object)"IS_DELE_", (Object)0);
        List tunnels = this.list((Wrapper)wrapper);
        List biggestList = tunnels.stream().filter(tunnelInformation -> Objects.equals(tunnelInformation.getType(), "1")).collect(Collectors.toList());
        List biggerList = tunnels.stream().filter(tunnelInformation -> Objects.equals(tunnelInformation.getType(), "2")).collect(Collectors.toList());
        List bigList = tunnels.stream().filter(tunnelInformation -> Objects.equals(tunnelInformation.getType(), "3")).collect(Collectors.toList());
        List smallList = tunnels.stream().filter(tunnelInformation -> Objects.equals(tunnelInformation.getType(), "4")).collect(Collectors.toList());
        String biggest = String.format("%.2f", biggestList.stream().mapToDouble(TunnelInformation::getLength).sum()) + "/" + biggestList.size();
        String bigger = String.format("%.2f", biggerList.stream().mapToDouble(TunnelInformation::getLength).sum()) + "/" + biggerList.size();
        String big = String.format("%.2f", bigList.stream().mapToDouble(TunnelInformation::getLength).sum()) + "/" + bigList.size();
        String small = String.format("%.2f", smallList.stream().mapToDouble(TunnelInformation::getLength).sum()) + "/" + smallList.size();
        String all = String.format("%.2f", tunnels.stream().mapToDouble(TunnelInformation::getLength).sum()) + "/" + tunnels.size();
        orgVO.setBig(big);
        orgVO.setBigger(bigger);
        orgVO.setBiggest(biggest);
        orgVO.setSmall(small);
        orgVO.setAll(all);
        if ("4".equals(orgVO.getGrade())) {
            orgVO.setRoadSegmentId(ids.get(0));
        }
        return orgVO;
    }

    public static List<Org> getOrgChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            TunnelInformationManagerImpl.getOrgChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    public static List<Org4tunnelVO> getChild(List<Org4tunnelVO> allList, String pCode) {
        ArrayList<Org4tunnelVO> returnList = new ArrayList<Org4tunnelVO>();
        for (Org4tunnelVO entity : allList) {
            if (!pCode.equals(entity.getParentId())) continue;
            entity.setChirldren(TunnelInformationManagerImpl.getChild(allList, entity.getId()));
            returnList.add(entity);
        }
        return returnList;
    }

    private List<String> getOrgIds(String currentOrgId) {
        List orgList = this.orgManager.getByParentId(currentOrgId);
        List<String> collect = orgList.stream().map(Org::getId).collect(Collectors.toList());
        collect.add(currentOrgId);
        return collect;
    }

    @Override
    public PageList<TunnelCheckVo> queryTunnel(QueryFilter<TunnelInformation> queryFilter) throws Exception {
        String baseContextCurrentOrgId;
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty((CharSequence)(baseContextCurrentOrgId = this.baseContext.getCurrentOrgId()))) {
            this.permissionUtils.addPermission(queryFilter);
        }
        List sorter = queryFilter.getSorter();
        for (FieldSort fieldSort : sorter) {
            if (!fieldSort.getProperty().equals("checkDate")) continue;
            fieldSort.setProperty("CHECK_DATE_");
        }
        IPage<TunnelCheckVo> result = ((TunnelInformationDao)this.baseMapper).queryTunnel((IPage<TunnelInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<TunnelInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        LocalDate today = LocalDate.now();
        for (TunnelCheckVo record : records) {
            Date checkDate;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq(record.getCheckDate() != null, (Object)"CHECK_DATE_", (Object)record.getCheckDate());
            queryWrapper.eq((Object)"TUNNEL_ID_", (Object)record.getId());
            List tunnelRegularChecks = this.tunnelOftenCheckDao.selectList((Wrapper)queryWrapper);
            if (tunnelRegularChecks != null && tunnelRegularChecks.size() > 0) {
                record.setEvaluateValue(((TunnelOftenCheck)((Object)tunnelRegularChecks.get(0))).getEvaluateValue());
            }
            if (null == (checkDate = record.getCheckDate())) {
                record.setTemporary(0);
                continue;
            }
            Instant instant = checkDate.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDate oldDate = instant.atZone(zoneId).toLocalDate();
            long dateLength = today.until(oldDate, ChronoUnit.DAYS);
            record.setAlreadyCheckDays((int)Math.abs(dateLength));
            Date checkNewDay = record.getCheckNewDay();
            Instant instantNew = checkNewDay.toInstant();
            LocalDate newDate = instantNew.atZone(zoneId).toLocalDate();
            long dateDivide = today.until(newDate, ChronoUnit.DAYS);
            if (dateDivide < 0L) {
                dateDivide = 0L;
            }
            record.setCheckDays((int)dateDivide);
        }
        return new PageList(result);
    }

    @Override
    public TunnelInformation getTunnelById(String id) {
        TunnelInformation tunnelInformation = (TunnelInformation)((Object)((TunnelInformationDao)this.baseMapper).selectById((Serializable)((Object)id)));
        List<Accessory> accessories = this.accessoryManager.getAccessoryBySourceId(id);
        ArrayList<Accessory> accessoriesFrontView = new ArrayList<Accessory>();
        ArrayList<Accessory> accessoriesLateralView = new ArrayList<Accessory>();
        ArrayList<Accessory> accessoriesTwoDimensionalView = new ArrayList<Accessory>();
        if (accessories != null && accessories.size() > 0) {
            accessories.forEach(s -> {
                String group = s.getGroup();
                if ("frontView".equalsIgnoreCase(group)) {
                    accessoriesFrontView.add((Accessory)((Object)s));
                }
                if ("lateralView".equalsIgnoreCase(group)) {
                    accessoriesLateralView.add((Accessory)((Object)s));
                }
                if ("twoDimensionalPlan".equalsIgnoreCase(group)) {
                    accessoriesTwoDimensionalView.add((Accessory)((Object)s));
                }
            });
        }
        tunnelInformation.setAccessoriesFrontView(accessoriesFrontView);
        tunnelInformation.setAccessoriesLateralView(accessoriesLateralView);
        tunnelInformation.setAccessoriesTwoDimensionalView(accessoriesTwoDimensionalView);
        return tunnelInformation;
    }

    @Override
    public void checkNumber(TunnelInformation tunnelInformation) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)tunnelInformation.getId())) {
            queryWrapper.notIn((Object)"id_", new Object[]{tunnelInformation.getId()});
        }
        queryWrapper.eq((Object)"NUMBER_", (Object)tunnelInformation.getNumber());
        queryWrapper.eq((Object)"IS_DELE_", (Object)"0");
        List list = ((TunnelInformationDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (list.size() > 0) {
            throw new RuntimeException("\u8be5\u96a7\u9053\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
    }

    @Override
    public Integer getSn() {
        HashMap<String, String> map = new HashMap<String, String>();
        IUser user = ContextUtil.getCurrentUser();
        if (ObjectUtils.isNotEmpty((Object)user)) {
            map.put("tenant_id_", user.getTenantId());
        }
        return this.getNextSequence(map);
    }

    @Override
    public PageList<TunnelInformation> queryTunnelInformation(QueryFilter<TunnelInformation> queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        IPage<TunnelInformation> result = ((TunnelInformationDao)this.baseMapper).queryTunnelInformation((IPage<TunnelInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<TunnelInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<TunnelRegularVo> queryTunnelRegular(QueryFilter<TunnelInformation> queryFilter) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.baseContext.getCurrentOrgId())) {
            this.permissionUtils.addPermission(queryFilter);
        }
        List sorter = queryFilter.getSorter();
        for (FieldSort fieldSort : sorter) {
            if (!fieldSort.getProperty().equals("checkDate")) continue;
            fieldSort.setProperty("CHECK_DATE_");
        }
        IPage<TunnelRegularVo> result = ((TunnelInformationDao)this.baseMapper).queryTunnelRegularCheckVo((IPage<TunnelInformation>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<TunnelInformation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        LocalDate today = LocalDate.now();
        for (TunnelRegularVo record : records) {
            Date checkDate;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq(record.getCheckDate() != null, (Object)"CHECK_DATE_", (Object)record.getCheckDate());
            queryWrapper.eq((Object)"TUNNEL_ID_", (Object)record.getId());
            List tunnelRegularChecks = this.tunnelRegularCheckDao.selectList((Wrapper)queryWrapper);
            if (tunnelRegularChecks != null && tunnelRegularChecks.size() > 0) {
                record.setSkillScoreValue(((TunnelRegularCheck)((Object)tunnelRegularChecks.get(0))).getSkillScoreValue());
            }
            if (null == (checkDate = record.getCheckDate())) {
                record.setTemporary(0);
                continue;
            }
            Instant instant = checkDate.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDate oldDate = instant.atZone(zoneId).toLocalDate();
            long dateLength = today.until(oldDate, ChronoUnit.DAYS);
            record.setAlreadyCheckDays((int)Math.abs(dateLength));
            Date checkNewDay = record.getCheckNewDay();
            Instant instantNew = checkNewDay.toInstant();
            LocalDate newDate = instantNew.atZone(zoneId).toLocalDate();
            long dateDivide = today.until(newDate, ChronoUnit.DAYS);
            if (dateDivide < 0L) {
                dateDivide = 0L;
            }
            record.setCheckDays((int)dateDivide);
        }
        return new PageList(result);
    }

    @Override
    public void saveTunnel(TunnelInformation tunnelInformation) {
        List<Accessory> accessoriesTwoDimensionalView;
        List<Accessory> accessoriesLateralView;
        this.save((Object)tunnelInformation);
        List<Accessory> accessoriesFrontView = tunnelInformation.getAccessoriesFrontView();
        if (null != accessoriesFrontView && accessoriesFrontView.size() > 0) {
            accessoriesFrontView.forEach(s -> {
                s.setSourceId(tunnelInformation.getId());
                s.setGroup("frontView");
            });
            this.accessoryManager.saveBatch(accessoriesFrontView);
        }
        if (null != (accessoriesLateralView = tunnelInformation.getAccessoriesLateralView()) && accessoriesLateralView.size() > 0) {
            accessoriesLateralView.forEach(s -> {
                s.setSourceId(tunnelInformation.getId());
                s.setGroup("lateralView");
            });
            this.accessoryManager.saveBatch(accessoriesLateralView);
        }
        if (null != (accessoriesTwoDimensionalView = tunnelInformation.getAccessoriesTwoDimensionalView()) && accessoriesTwoDimensionalView.size() > 0) {
            accessoriesTwoDimensionalView.forEach(s -> {
                s.setSourceId(tunnelInformation.getId());
                s.setGroup("twoDimensionalPlan");
            });
            this.accessoryManager.saveBatch(accessoriesTwoDimensionalView);
        }
    }

    @Override
    public void updateTunnel(TunnelInformation tunnelInformation) {
        List<Accessory> accessoriesTwoDimensionalView;
        List<Accessory> accessoriesLateralView;
        this.update((Model)tunnelInformation);
        this.accessoryManager.delAccessoryBySourceId(tunnelInformation.getId());
        List<Accessory> accessoriesFrontView = tunnelInformation.getAccessoriesFrontView();
        if (null != accessoriesFrontView && accessoriesFrontView.size() > 0) {
            accessoriesFrontView.forEach(s -> {
                s.setSourceId(tunnelInformation.getId());
                s.setGroup("frontView");
            });
            this.accessoryManager.saveBatch(accessoriesFrontView);
        }
        if (null != (accessoriesLateralView = tunnelInformation.getAccessoriesLateralView()) && accessoriesLateralView.size() > 0) {
            accessoriesLateralView.forEach(s -> {
                s.setSourceId(tunnelInformation.getId());
                s.setGroup("lateralView");
            });
            this.accessoryManager.saveBatch(accessoriesLateralView);
        }
        if (null != (accessoriesTwoDimensionalView = tunnelInformation.getAccessoriesTwoDimensionalView()) && accessoriesTwoDimensionalView.size() > 0) {
            accessoriesTwoDimensionalView.forEach(s -> {
                s.setSourceId(tunnelInformation.getId());
                s.setGroup("twoDimensionalPlan");
            });
            this.accessoryManager.saveBatch(accessoriesTwoDimensionalView);
        }
    }
}

