package com.artfess.cqxy.bidManagement.dao;

import com.artfess.cqxy.bidManagement.model.BiddingPriceExamine;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

/**
 * 招投标管理 - 清单限价 - 审核(BiddingPriceExamine)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-04-08 11:08:31
 */
public interface BiddingPriceExamineDao extends BaseMapper<BiddingPriceExamine> {

    /**
     * 通过ID获取数 据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    BiddingPriceExamine getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<BiddingPriceExamine> queryAllByPage(IPage<BiddingPriceExamine> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BiddingPriceExamine> convert2Wrapper);

}

