package com.artfess.base.service;

import javax.annotation.Resource;

import com.artfess.base.feign.SystemConfigFeignService;
import org.springframework.stereotype.Service;



/**
 * 获取系统属性的服务类
 * <p>添加了缓存</p>
 *
 * @company 广州宏天软件股份有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2020年6月16日
 */
@Service
public class PropertyService {
	@Resource
    SystemConfigFeignService systemConfigFeignService;

	public String getProperty(String alias, String defaultValue) {
		return systemConfigFeignService.getByAlias(alias, defaultValue);
	}
}
