/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.service;

import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.exception.CertificateException;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.MapUtil;
import com.artfess.base.util.PlatformConsts;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.TenantManageManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.manager.UserRoleManager;
import com.artfess.uc.model.TenantManage;
import com.artfess.uc.model.User;
import com.artfess.uc.model.UserRole;
import com.artfess.uc.service.UserDetailsFacade;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.annotation.Primary;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Primary
@Service
public class UserManagerDetailsServiceImpl
implements UserDetailsService {
    @Resource
    UserManager userManager;
    @Resource
    UserRoleManager userRoleManager;
    @Resource
    UserDetailsFacade userDetailsFacade;
    @Resource
    OrgManager orgManager;
    @Resource
    TenantManageManager tenantManageManager;

    @Cacheable(value={"bpm:uc:userAccount"}, key="#username", shortExpire=true)
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, CertificateException {
        User user = this.convertUserDetails2User(this.loadUserByUsernameFromDB(username));
        Assert.notNull((Object)user, (String)("UserManagerDetailsServiceImpl.loadUserByUsernameFromDB  returned null for username " + username + ". " + "This is an interface contract violation"));
        return user;
    }

    private UserDetails loadUserByUsernameFromDB(String username) {
        try {
            User user = this.userManager.getByAccount(username);
            if (BeanUtils.isEmpty((Object)user)) {
                throw new UsernameNotFoundException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
            }
            if (StringUtil.isNotEmpty((String)user.getTenantId()) && !"-1".equals(user.getTenantId())) {
                TenantManage tenant = (TenantManage)this.tenantManageManager.get((Serializable)((Object)user.getTenantId()));
                if (BeanUtils.isEmpty((Object)((Object)tenant))) {
                    throw new CertificateException("\u672a\u83b7\u53d6\u5230\u7528\u6237\u79df\u6237\u4fe1\u606f\u3002");
                }
                if (!"enable".equals(tenant.getStatus())) {
                    throw new CertificateException("\u7528\u6237\u6240\u5c5e\u79df\u6237\u672a\u542f\u7528\u3002");
                }
            }
            ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
            if (user.isAdmin()) {
                authorities.add((GrantedAuthority)PlatformConsts.ROLE_GRANT_SUPER);
            }
            List<UserRole> userRoles = this.userRoleManager.getListByUserId(user.getId());
            for (UserRole userRole : userRoles) {
                SimpleGrantedAuthority role = new SimpleGrantedAuthority(userRole.getAlias());
                authorities.add((GrantedAuthority)role);
            }
            user.setAttributes(this.getOrgIdByUserId(user.getUserId()));
            return this.userDetailsFacade.loadUserDetails(authorities, user);
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UsernameNotFoundException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01", (Throwable)e);
        }
    }

    private Map<String, String> getOrgIdByUserId(String userId) {
        List<String> subOrgByIds;
        HashMap<String, String> map = new HashMap<String, String>();
        List<Map<String, Object>> orgIdMapList = this.orgManager.getOrgIdMapByUserId(userId);
        HashSet<String> orgIds = new HashSet<String>();
        orgIdMapList.forEach(orgIdMap -> {
            String orgId = MapUtil.getString((Map)orgIdMap, (String)"orgId");
            String isMaster = MapUtil.getString((Map)orgIdMap, (String)"isMaster");
            if (StringUtil.isNotEmpty((String)orgId)) {
                orgIds.add(orgId);
            }
            if ("1".equals(isMaster)) {
                map.put("CURRENT_USER_MAIN_ORGID", orgId);
            }
        });
        if (!orgIds.isEmpty()) {
            map.put("CURRENT_USER_ORGIDS", String.join((CharSequence)",", orgIds));
        }
        if (BeanUtils.isNotEmpty(subOrgByIds = this.orgManager.getSubOrgByIds(orgIds))) {
            HashSet<String> orgIdsAndSub = new HashSet<String>(subOrgByIds);
            orgIdsAndSub.addAll(orgIds);
            map.put("CURRENT_USER_SUB_ORGIDS", String.join((CharSequence)",", orgIdsAndSub));
        }
        return map;
    }

    private User convertUserDetails2User(UserDetails userDetails) {
        if (BeanUtils.isEmpty((Object)userDetails)) {
            return null;
        }
        if (userDetails instanceof User) {
            return (User)userDetails;
        }
        IUser iuser = (IUser)userDetails;
        String userId = iuser.getUserId();
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        Collection extendsAuthorities = iuser.getAuthorities();
        if (BeanUtils.isNotEmpty((Object)extendsAuthorities)) {
            authorities.addAll(extendsAuthorities);
        }
        String account = iuser.getAccount();
        String fullname = iuser.getFullname();
        String password = iuser.getPassword();
        Integer status = iuser.getStatus();
        String email = iuser.getEmail();
        String mobile = iuser.getMobile();
        LocalDateTime pwdCreateTime = iuser.getPwdCreateTime();
        User user = new User(account, fullname, password, authorities);
        user.setUserId(userId);
        user.setEmail(email);
        user.setMobile(mobile);
        user.setStatus(status);
        user.setPwdCreateTime(pwdCreateTime);
        user.setLastLoginTime(iuser.getLastLoginTime());
        user.setLockedStatus(iuser.getLockedStatus());
        user.setLockedTime(iuser.getLockedTime());
        user.setClientId(iuser.getClientId());
        user.setClientToken(iuser.getClientToken());
        return user;
    }
}

