/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.kafka;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.kafka.config.KafkaListenerEndpointRegistry;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.stereotype.Component;

@Component
public class KafkaConsumerStarter
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumerStarter.class);
    private final KafkaListenerEndpointRegistry registry;

    @Autowired
    public KafkaConsumerStarter(KafkaListenerEndpointRegistry registry) {
        this.registry = registry;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        try {
            String[] listenerIds;
            for (String listenerId : listenerIds = new String[]{"orgListenerContainer", "userListenerContainer", "roleListenerContainer"}) {
                MessageListenerContainer container = this.registry.getListenerContainer(listenerId);
                if (container != null && !container.isRunning()) {
                    container.start();
                    log.info("Kafka Listener [{}] \u5df2\u624b\u52a8\u542f\u52a8", (Object)listenerId);
                    continue;
                }
                log.warn("Kafka Listener [{}] \u672a\u6ce8\u518c\u6216\u5df2\u5728\u8fd0\u884c", (Object)listenerId);
            }
        }
        catch (Exception e) {
            log.error("KafkaListener \u542f\u52a8\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

