/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.open.manager.impl;

import com.artfess.base.entity.BizDelModel;
import com.artfess.base.model.CommonResult;
import com.artfess.redis.util.RedisUtil;
import com.artfess.rescue.base.manager.BizBaseStationaryManager;
import com.artfess.rescue.base.manager.BizElectronicFenecManager;
import com.artfess.rescue.base.model.BizBaseCar;
import com.artfess.rescue.base.model.BizBaseStationary;
import com.artfess.rescue.base.model.BizBaseTeam;
import com.artfess.rescue.base.model.BizElectronicFenec;
import com.artfess.rescue.event.manager.BizRescueInfoManager;
import com.artfess.rescue.event.model.BizRescueInfo;
import com.artfess.rescue.open.dto.CameraInfoDTO;
import com.artfess.rescue.open.dto.OpenBaseQueryDTO;
import com.artfess.rescue.open.manager.OpenBaseManager;
import com.artfess.rescue.open.manager.OpenCountManager;
import com.artfess.rescue.open.vo.BaseCarVO;
import com.artfess.rescue.open.vo.OpenBaseListVO;
import com.artfess.rescue.video.manager.BizVideoMonitorPointInfoManager;
import com.artfess.rescue.video.model.BizVideoMonitorPointInfo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OpenBaseManagerImpl
implements OpenBaseManager {
    private static final Logger log = LoggerFactory.getLogger(OpenBaseManagerImpl.class);
    @Resource
    private BizRescueInfoManager rescueInfoManager;
    @Resource
    private BizBaseStationaryManager baseRescueManager;
    @Resource
    private OpenCountManager openCountManager;
    @Resource
    private BizElectronicFenecManager electronicFenecManager;
    @Resource
    private BizVideoMonitorPointInfoManager videoMonitorPointInfoManager;
    @Resource
    private RedisUtil redisUtil;

    @Override
    public CommonResult<List<OpenBaseListVO>> getTask(OpenBaseQueryDTO dto) {
        ArrayList<OpenBaseListVO> vos = new ArrayList<OpenBaseListVO>();
        LambdaQueryWrapper rescueQueryWrapper = new LambdaQueryWrapper();
        rescueQueryWrapper.eq(BizRescueInfo::getIsDele, (Object)"0");
        if (CollectionUtils.isNotEmpty(dto.getRoadIds())) {
            rescueQueryWrapper.in(BizRescueInfo::getRoadId, dto.getRoadIds());
        }
        rescueQueryWrapper.eq(BizRescueInfo::getRescueStatus, (Object)2);
        rescueQueryWrapper.between(BizRescueInfo::getRescueTime, (Object)dto.getStartTime(), (Object)dto.getEndTime());
        List rescueInfos = this.rescueInfoManager.list((Wrapper)rescueQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)rescueInfos)) {
            for (BizRescueInfo rescueInfo : rescueInfos) {
                vos.add(new OpenBaseListVO(rescueInfo.getId(), rescueInfo.getLng(), rescueInfo.getLat()));
            }
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", vos);
    }

    @Override
    public CommonResult<List<OpenBaseListVO>> getPointPatrol(OpenBaseQueryDTO dto) {
        List<OpenBaseListVO> vos = this.getBaseRescues(dto, 1);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", vos);
    }

    @Override
    public CommonResult<List<OpenBaseListVO>> getPointRescue(OpenBaseQueryDTO dto) {
        List<OpenBaseListVO> vos = this.getBaseRescues(dto, 2);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", vos);
    }

    @Override
    public CommonResult<List<BaseCarVO>> getCarPatrol(OpenBaseQueryDTO dto) {
        List<BaseCarVO> vos = this.getBaseCar(dto, 1);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", vos);
    }

    @Override
    public CommonResult<List<BaseCarVO>> getCarRescue(OpenBaseQueryDTO dto) {
        List<BaseCarVO> vos = this.getBaseCar(dto, 2);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", vos);
    }

    @Override
    public CommonResult<List<BizElectronicFenec>> getRescueRegion(OpenBaseQueryDTO dto) {
        List electronicFenecs = new ArrayList();
        List<BizBaseTeam> baseTeams = this.openCountManager.getBaseTeams(dto);
        if (CollectionUtils.isNotEmpty(baseTeams)) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(BizDelModel::getIsDele, (Object)"0");
            wrapper.in(BizElectronicFenec::getTeamId, (Collection)baseTeams.stream().map(BizBaseTeam::getId).collect(Collectors.toList()));
            electronicFenecs = this.electronicFenecManager.list();
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", electronicFenecs);
    }

    private List<BaseCarVO> getBaseCar(OpenBaseQueryDTO dto, Integer type) {
        ArrayList<BaseCarVO> vos = new ArrayList<BaseCarVO>();
        List<BizBaseCar> cars = this.openCountManager.getBaseCars(dto, type);
        if (CollectionUtils.isEmpty(cars)) {
            return vos;
        }
        List<BizVideoMonitorPointInfo> pointInfos = this.getVehicleCameras();
        if (CollectionUtils.isEmpty(pointInfos)) {
            return vos;
        }
        Map<String, List<BizVideoMonitorPointInfo>> carNumberMap = this.groupByCarNumber(pointInfos);
        for (BizBaseCar car : cars) {
            List<BizVideoMonitorPointInfo> pointInfoList;
            long olineNum;
            if (!carNumberMap.containsKey(car.getCarNumber()) || (olineNum = (pointInfoList = carNumberMap.get(car.getCarNumber())).stream().filter(e -> e.getStatus() == 1).count()) <= 0L) continue;
            BaseCarVO vo = this.getBaseCarVO(car, pointInfoList);
            vos.add(vo);
        }
        return vos;
    }

    private List<OpenBaseListVO> getBaseRescues(OpenBaseQueryDTO dto, Integer type) {
        List baseRescues;
        ArrayList<OpenBaseListVO> vos = new ArrayList<OpenBaseListVO>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BizDelModel::getIsDele, (Object)"0");
        wrapper.eq(BizBaseStationary::getType, (Object)type);
        if (CollectionUtils.isNotEmpty(dto.getRoadIds())) {
            wrapper.in(BizBaseStationary::getRoadId, dto.getRoadIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)(baseRescues = this.baseRescueManager.list((Wrapper)wrapper)))) {
            for (BizBaseStationary baseRescue : baseRescues) {
                String lng = baseRescue.getLng() == null ? null : baseRescue.getLng().toString();
                String lat = baseRescue.getLat() == null ? null : baseRescue.getLat().toString();
                vos.add(new OpenBaseListVO(baseRescue.getId(), lng, lat));
            }
        }
        return vos;
    }

    private List<BizVideoMonitorPointInfo> getVehicleCameras() {
        LambdaQueryWrapper pointInfoWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)pointInfoWrapper.like(BizVideoMonitorPointInfo::getName, (Object)"\u8f66\u8f7d")).or()).like(BizVideoMonitorPointInfo::getName, (Object)"-\u4e91\u53f0")).or()).like(BizVideoMonitorPointInfo::getName, (Object)"\u5e03\u63a7\u7403");
        return this.videoMonitorPointInfoManager.list((Wrapper)pointInfoWrapper);
    }

    public Map<String, List<BizVideoMonitorPointInfo>> groupByCarNumber(List<BizVideoMonitorPointInfo> pointInfos) {
        String carPlateRegex = "[\u4e00-\u9fa5][A-Z0-9]{5,7}";
        String typeRegex = "(\u8f66\u8f7d|\u4e91\u53f0|\u5e03\u63a7\u7403)";
        HashMap<String, List<BizVideoMonitorPointInfo>> carNumberPointMap = new HashMap<String, List<BizVideoMonitorPointInfo>>();
        for (BizVideoMonitorPointInfo pointInfo : pointInfos) {
            String name = pointInfo.getName();
            Matcher matcher = Pattern.compile(carPlateRegex).matcher(name);
            if (!matcher.find()) continue;
            String carNumber = matcher.group();
            Matcher typeMatcher = Pattern.compile(typeRegex).matcher(name);
            if (typeMatcher.find()) {
                String type = typeMatcher.group();
                pointInfo.setStatusName(type);
            }
            carNumberPointMap.computeIfAbsent(carNumber, k -> new ArrayList()).add(pointInfo);
        }
        return carNumberPointMap;
    }

    private BaseCarVO getBaseCarVO(BizBaseCar car, List<BizVideoMonitorPointInfo> pointInfoList) {
        BaseCarVO vo = new BaseCarVO();
        vo.setId(car.getId());
        vo.setCarNumber(car.getCarNumber());
        ArrayList<CameraInfoDTO> cameraInfos = new ArrayList<CameraInfoDTO>();
        for (BizVideoMonitorPointInfo bizVideoMonitorPointInfo : pointInfoList) {
            String loc;
            CameraInfoDTO cameraInfo = new CameraInfoDTO();
            cameraInfo.setId(bizVideoMonitorPointInfo.getId());
            cameraInfo.setName(bizVideoMonitorPointInfo.getName());
            cameraInfo.setStatus(bizVideoMonitorPointInfo.getStatus());
            cameraInfo.setCameraType(bizVideoMonitorPointInfo.getStatusName());
            cameraInfos.add(cameraInfo);
            if (1 != bizVideoMonitorPointInfo.getStatus()) continue;
            String device = bizVideoMonitorPointInfo.getDeviceIndexCode();
            Object carGpsObj = this.redisUtil.get("car:gps:" + device);
            if (!ObjectUtils.isNotEmpty((Object)carGpsObj) || !StringUtils.isNotEmpty((CharSequence)(loc = (String)carGpsObj)) || vo.getLng() != null && vo.getLat() != null) continue;
            String[] locArr = loc.split("-");
            String latitude = locArr[0];
            String longitude = locArr[1];
            vo.setLat(latitude.length() > 9 ? latitude.substring(0, 9) : latitude);
            vo.setLng(longitude.length() > 9 ? longitude.substring(0, 9) : longitude);
        }
        vo.setCameraInfos(cameraInfos);
        return vo;
    }
}

