/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.video.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.redis.util.RedisUtil;
import com.artfess.rescue.video.manager.GpsService;
import com.artfess.rescue.video.util.CoordinateTransform;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GpsServiceImpl
implements GpsService {
    private static final Logger log = LoggerFactory.getLogger(GpsServiceImpl.class);
    @Resource
    private RedisUtil redisUtil;

    @Override
    public void save(String payload) {
        try {
            JSONObject jsonObject = JSON.parseObject((String)payload);
            JSONObject params = jsonObject.getJSONObject("params");
            JSONArray events = params.getJSONArray("events");
            for (Object event : events) {
                if (event == null) continue;
                JSONObject ev = (JSONObject)event;
                JSONObject data = ev.getJSONObject("data");
                Double[] transform = CoordinateTransform.transformNew(data.getInteger("latitude"), data.getInteger("longitude"));
                log.debug("\u7ecf\u7eac\u5ea6\uff1a{} - {}", (Object)transform[0], (Object)transform[1]);
                log.debug("deviceIndexCode\uff1a{}", (Object)data.getString("deviceIndexCode"));
                this.redisUtil.set("car:gps:" + data.getString("deviceIndexCode"), (Object)(transform[0] + "-" + transform[1]), 600L);
            }
        }
        catch (Exception e) {
            log.error("gps\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff0cpayload\u4fe1\u606f\u4e3a\uff1a{}\uff0c\u62a5\u9519\u4fe1\u606f\u4e3a\uff1a{}", (Object)payload, (Object)e.getMessage());
        }
    }
}

