/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.event.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.WordUtil;
import com.artfess.rescue.base.manager.BizBaseRoadManager;
import com.artfess.rescue.base.model.BizBaseRoad;
import com.artfess.rescue.event.dao.BizEventProgressDao;
import com.artfess.rescue.event.manager.BizEventProgressManager;
import com.artfess.rescue.event.model.BizEventProgress;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class BizEventProgressManagerImpl
extends BaseManagerImpl<BizEventProgressDao, BizEventProgress>
implements BizEventProgressManager {
    @Resource
    BizBaseRoadManager roadManager;

    @Override
    public ResponseEntity<org.springframework.core.io.Resource> export(QueryFilter<BizEventProgress> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(-1);
        IPage<BizEventProgress> iPage = ((BizEventProgressDao)this.baseMapper).progressList((IPage<BizEventProgress>)this.convert2IPage(pageBean), (Wrapper<BizEventProgress>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List progresses = iPage.getRecords();
        if (progresses == null || progresses.isEmpty()) {
            throw new BaseException("\u6682\u65e0\u53ef\u5bfc\u51fa\u7684\u6570\u636e!!!");
        }
        String filePath = "/word/\u7a81\u53d1\u4e8b\u4ef6\u4fe1\u606f\u62a5\u9001\u4e13\u62a5.ftl";
        String docName = "\u7a81\u53d1\u4e8b\u4ef6\u4fe1\u606f";
        String outputZipPath = "\u7a81\u53d1\u4e8b\u4ef6\u8fdb\u5c55.zip";
        File zipFile = WordUtil.generateAndZipWordFiles((List)progresses, (String)filePath, (String)docName, (String)outputZipPath);
        if (zipFile != null) {
            FileSystemResource resource = new FileSystemResource(zipFile);
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", "attachment; filename=output.zip");
            ResponseEntity response = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(zipFile.length()).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
            CompletableFuture.runAsync(() -> {
                try {
                    TimeUnit.SECONDS.sleep(30L);
                    for (int checkCount = 0; checkCount < 5; ++checkCount) {
                        if (!this.isFileBeingAccessed(zipFile)) {
                            zipFile.delete();
                            break;
                        }
                        TimeUnit.SECONDS.sleep(10L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
            return response;
        }
        return ResponseEntity.notFound().build();
    }

    private boolean isFileBeingAccessed(File file) {
        try {
            return !file.renameTo(file);
        }
        catch (Exception e) {
            return true;
        }
    }

    public BizEventProgress getById(Serializable id) {
        BizBaseRoad road;
        BizEventProgress progress = (BizEventProgress)((Object)((BizEventProgressDao)this.getBaseMapper()).selectById(id));
        if (progress != null && !StringUtil.isEmpty((String)progress.getRoadId()) && (road = (BizBaseRoad)this.roadManager.get((Serializable)((Object)progress.getRoadId()))) != null) {
            progress.setRoadName(road.getName());
        }
        return progress;
    }
}

